/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.injection.producer.ejb.SessionBeanInjectionTarget;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionTargetFactoryImpl<T>
implements WeldInjectionTargetFactory<T> {
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> type;
    private final InjectionTargetService injectionTargetService;
    private final InjectionServices injectionServices;

    protected InjectionTargetFactoryImpl(AnnotatedType<T> type2, BeanManagerImpl manager) {
        this.manager = manager;
        this.type = manager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type2, manager.getId());
        this.injectionTargetService = manager.getServices().get(InjectionTargetService.class);
        this.injectionServices = manager.getServices().get(InjectionServices.class);
    }

    @Override
    public WeldInjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        return this.createInjectionTarget(bean, false);
    }

    @Override
    public WeldInjectionTarget<T> createInterceptorInjectionTarget() {
        return this.createInjectionTarget(null, true);
    }

    private WeldInjectionTarget<T> createInjectionTarget(Bean<T> bean, boolean interceptor) {
        try {
            return this.validate(this.createInjectionTarget(this.type, bean, interceptor));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BasicInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type2, Bean<T> bean, boolean interceptor) {
        BasicInjectionTarget<T> injectionTarget = this.chooseInjectionTarget(type2, bean, interceptor);
        this.initialize(injectionTarget);
        this.postProcess(injectionTarget);
        return injectionTarget;
    }

    private BasicInjectionTarget<T> chooseInjectionTarget(EnhancedAnnotatedType<T> type2, Bean<T> bean, boolean interceptor) {
        if (bean instanceof Decorator || type2.isAnnotationPresent(javax.decorator.Decorator.class)) {
            return new DecoratorInjectionTarget<T>(type2, bean, this.manager);
        }
        if (type2.isAbstract()) {
            if (type2.getJavaClass().isInterface()) {
                throw BeanLogger.LOG.injectionTargetCannotBeCreatedForInterface(type2);
            }
            BeanLogger.LOG.injectionTargetCreatedForAbstractClass(type2.getJavaClass());
            return new NonProducibleInjectionTarget<T>(type2, bean, this.manager);
        }
        if (!Reflections.isTopLevelOrStaticNestedClass(type2.getJavaClass())) {
            BeanLogger.LOG.injectionTargetCreatedForNonStaticInnerClass(type2.getJavaClass());
            return new NonProducibleInjectionTarget<T>(type2, bean, this.manager);
        }
        if (Beans.getBeanConstructor(type2) == null) {
            if (bean != null) {
                throw BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructorException(type2.getJavaClass());
            }
            BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructor(type2.getJavaClass());
            return new NonProducibleInjectionTarget<T>(type2, null, this.manager);
        }
        if (bean instanceof SessionBean) {
            return SessionBeanInjectionTarget.of(type2, (SessionBean)bean, this.manager);
        }
        if (bean instanceof Interceptor || type2.isAnnotationPresent(javax.interceptor.Interceptor.class)) {
            return BeanInjectionTarget.forCdiInterceptor(type2, bean, this.manager);
        }
        if (interceptor) {
            return BasicInjectionTarget.createNonCdiInterceptor(type2, this.manager);
        }
        return BeanInjectionTarget.createDefault(type2, bean, this.manager);
    }

    protected InjectionTarget<T> createMessageDrivenInjectionTarget(InternalEjbDescriptor<T> descriptor) {
        EnhancedAnnotatedType<T> implementationClass = Beans.getEjbImplementationClass(descriptor, this.manager, this.type);
        AbstractInstantiator instantiator = null;
        instantiator = this.type.equals(implementationClass) ? new DefaultInstantiator<T>(this.type, null, this.manager) : SubclassedComponentInstantiator.forSubclassedEjb(this.type, implementationClass, null, this.manager);
        return this.prepareInjectionTarget(BasicInjectionTarget.createDefault(this.type, null, this.manager, instantiator));
    }

    private BasicInjectionTarget<T> initialize(BasicInjectionTarget<T> injectionTarget) {
        this.injectionTargetService.addInjectionTargetToBeInitialized(this.type, injectionTarget);
        return injectionTarget;
    }

    private <I extends InjectionTarget<T>> I validate(I injectionTarget) {
        this.injectionTargetService.validateProducer(injectionTarget);
        return injectionTarget;
    }

    private void postProcess(InjectionTarget<T> injectionTarget) {
        if (this.injectionServices != null) {
            this.injectionServices.registerInjectionTarget(injectionTarget, this.type.slim());
        }
    }

    private BasicInjectionTarget<T> prepareInjectionTarget(BasicInjectionTarget<T> injectionTarget) {
        try {
            this.postProcess(this.initialize(this.validate(injectionTarget)));
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public WeldInjectionTarget<T> createNonProducibleInjectionTarget() {
        return this.prepareInjectionTarget(new NonProducibleInjectionTarget<T>(this.type, null, this.manager));
    }
}

