/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.api.helpers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class TCCLSingletonProvider
extends SingletonProvider {
    @Override
    public <T> Singleton<T> create(Class<? extends T> type2) {
        return new TCCLSingleton();
    }

    private static class TCCLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new ConcurrentHashMap<ClassLoader, T>();

        private TCCLSingleton() {
        }

        @Override
        public T get(String id) {
            T instance = this.store.get(this.getClassLoader());
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + this.getClassLoader());
            }
            return instance;
        }

        @Override
        public void set(String id, T object) {
            this.store.put(this.getClassLoader(), object);
        }

        @Override
        public void clear(String id) {
            this.store.remove(this.getClassLoader());
        }

        @Override
        public boolean isSet(String id) {
            return this.store.containsKey(this.getClassLoader());
        }

        private ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

