/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.IdentitySet;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidationContext<T> {
    private static final Log log = LoggerFactory.make();
    private final ConstraintValidatorManager constraintValidatorManager;
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final ExecutableElement executable;
    private final Object[] executableParameters;
    private final Object executableReturnValue;
    private final Map<Class<?>, IdentitySet> processedBeansPerGroup;
    private final Map<Object, Set<PathImpl>> processedPathsPerBean;
    private final Map<BeanAndPath, IdentitySet> processedMetaConstraints;
    private final Set<ConstraintViolation<T>> failingConstraintViolations;
    private final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;
    private final ParameterNameProvider parameterNameProvider;
    private final boolean failFast;

    private ValidationContext(ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, ParameterNameProvider parameterNameProvider, boolean failFast, T rootBean, Class<T> rootBeanClass, ExecutableElement executable, Object[] executableParameters, Object executableReturnValue) {
        this.constraintValidatorManager = constraintValidatorManager;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.parameterNameProvider = parameterNameProvider;
        this.failFast = failFast;
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.executable = executable;
        this.executableParameters = executableParameters;
        this.executableReturnValue = executableReturnValue;
        this.processedBeansPerGroup = CollectionHelper.newHashMap();
        this.processedPathsPerBean = new IdentityHashMap<Object, Set<PathImpl>>();
        this.processedMetaConstraints = CollectionHelper.newHashMap();
        this.failingConstraintViolations = CollectionHelper.newHashSet();
    }

    public static ValidationContextBuilder getValidationContext(ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        return new ValidationContextBuilder(constraintValidatorManager, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public boolean isFailFastModeEnabled() {
        return this.failFast;
    }

    public ConstraintValidatorManager getConstraintValidatorManager() {
        return this.constraintValidatorManager;
    }

    public List<String> getParameterNames() {
        if (this.parameterNameProvider == null) {
            return null;
        }
        if (this.executable.getElementType() == ElementType.METHOD) {
            return this.parameterNameProvider.getParameterNames((Method)this.executable.getMember());
        }
        return this.parameterNameProvider.getParameterNames((Constructor)this.executable.getMember());
    }

    public Set<ConstraintViolation<T>> createConstraintViolations(ValueContext<?, ?> localContext, ConstraintValidatorContextImpl constraintValidatorContext) {
        HashSet<ConstraintViolation<T>> constraintViolations = CollectionHelper.newHashSet();
        for (ConstraintViolationCreationContext constraintViolationCreationContext : constraintValidatorContext.getConstraintViolationCreationContexts()) {
            ConstraintViolation<T> violation = this.createConstraintViolation(localContext, constraintViolationCreationContext, constraintValidatorContext.getConstraintDescriptor());
            constraintViolations.add(violation);
        }
        return constraintViolations;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public boolean isBeanAlreadyValidated(Object value, Class<?> group2, PathImpl path) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value, group2);
        if (alreadyValidated) {
            alreadyValidated = this.isAlreadyValidatedForPath(value, path);
        }
        return alreadyValidated;
    }

    public void markCurrentBeanAsProcessed(ValueContext<?, ?> valueContext) {
        this.markCurrentBeanAsProcessedForCurrentGroup(valueContext.getCurrentBean(), valueContext.getCurrentGroup());
        this.markCurrentBeanAsProcessedForCurrentPath(valueContext.getCurrentBean(), valueContext.getPropertyPath());
    }

    public void addConstraintFailures(Set<ConstraintViolation<T>> failingConstraintViolations) {
        this.failingConstraintViolations.addAll(failingConstraintViolations);
    }

    public Set<ConstraintViolation<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public ConstraintViolation<T> createConstraintViolation(ValueContext<?, ?> localContext, ConstraintViolationCreationContext constraintViolationCreationContext, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = constraintViolationCreationContext.getMessage();
        String interpolatedMessage = this.interpolate(messageTemplate, localContext.getCurrentValidatedValue(), descriptor, constraintViolationCreationContext.getExpressionVariables());
        Path path = constraintViolationCreationContext.getPath();
        if (this.executableParameters != null) {
            return ConstraintViolationImpl.forParameterValidation(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), this.executableParameters);
        }
        if (this.executableReturnValue != null) {
            return ConstraintViolationImpl.forReturnValueValidation(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), this.executableReturnValue);
        }
        return ConstraintViolationImpl.forBeanValidation(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType());
    }

    public boolean hasMetaConstraintBeenProcessed(Object bean, Path path, MetaConstraint<?> metaConstraint) {
        IdentitySet processedConstraints = this.processedMetaConstraints.get(new BeanAndPath(bean, path));
        return processedConstraints != null && processedConstraints.contains(metaConstraint);
    }

    public void markConstraintProcessed(Object bean, Path path, MetaConstraint<?> metaConstraint) {
        BeanAndPath beanAndPath = new BeanAndPath(bean, path);
        if (this.processedMetaConstraints.containsKey(beanAndPath)) {
            this.processedMetaConstraints.get(beanAndPath).add(metaConstraint);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(metaConstraint);
            this.processedMetaConstraints.put(beanAndPath, set);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationContext");
        sb.append("{rootBean=").append(this.rootBean);
        sb.append('}');
        return sb.toString();
    }

    private String interpolate(String messageTemplate, Object validatedValue, ConstraintDescriptor<?> descriptor, Map<String, Object> messageParameters) {
        MessageInterpolatorContext context = new MessageInterpolatorContext(descriptor, validatedValue, this.getRootBeanClass(), messageParameters);
        try {
            return this.messageInterpolator.interpolate(messageTemplate, context);
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw log.getExceptionOccurredDuringMessageInterpolationException(e);
        }
    }

    private boolean isAlreadyValidatedForPath(Object value, PathImpl path) {
        Set<PathImpl> pathSet = this.processedPathsPerBean.get(value);
        if (pathSet == null) {
            return false;
        }
        for (PathImpl p : pathSet) {
            if (!path.isRootPath() && !p.isRootPath() && !this.isSubPathOf(path, p) && !this.isSubPathOf(p, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubPathOf(Path p1, Path p2) {
        Iterator p1Iter = p1.iterator();
        Iterator p2Iter = p2.iterator();
        while (p1Iter.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iter.next();
            if (!p2Iter.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iter.next();
            if (p1Node.equals(p2Node)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value, Class<?> group2) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedBeansPerGroup.get(group2);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    private void markCurrentBeanAsProcessedForCurrentPath(Object value, PathImpl path) {
        if (this.processedPathsPerBean.containsKey(value)) {
            this.processedPathsPerBean.get(value).add(path);
        } else {
            HashSet<PathImpl> set = new HashSet<PathImpl>();
            set.add(path);
            this.processedPathsPerBean.put(value, set);
        }
    }

    private void markCurrentBeanAsProcessedForCurrentGroup(Object value, Class<?> group2) {
        if (this.processedBeansPerGroup.containsKey(group2)) {
            this.processedBeansPerGroup.get(group2).add(value);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(value);
            this.processedBeansPerGroup.put(group2, set);
        }
    }

    private static final class BeanAndPath {
        private final Object bean;
        private final Path path;
        private final int hashCode;

        private BeanAndPath(Object bean, Path path) {
            this.bean = bean;
            this.path = path;
            this.hashCode = this.createHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanAndPath that = (BeanAndPath)o;
            if (this.bean != that.bean) {
                return false;
            }
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int createHashCode() {
            int result = System.identityHashCode(this.bean);
            result = 31 * result + this.path.hashCode();
            return result;
        }
    }

    public static class ValidationContextBuilder {
        private final ConstraintValidatorManager constraintValidatorManager;
        private final MessageInterpolator messageInterpolator;
        private final ConstraintValidatorFactory constraintValidatorFactory;
        private final TraversableResolver traversableResolver;
        private final boolean failFast;

        private ValidationContextBuilder(ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
            this.constraintValidatorManager = constraintValidatorManager;
            this.messageInterpolator = messageInterpolator;
            this.constraintValidatorFactory = constraintValidatorFactory;
            this.traversableResolver = traversableResolver;
            this.failFast = failFast;
        }

        public <T> ValidationContext<T> forValidate(T rootBean) {
            Class<?> rootBeanClass = rootBean.getClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, rootBean, rootBeanClass, null, null, null);
        }

        public <T> ValidationContext<T> forValidateProperty(T rootBean) {
            Class<?> rootBeanClass = rootBean.getClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, rootBean, rootBeanClass, null, null, null);
        }

        public <T> ValidationContext<T> forValidateValue(Class<T> rootBeanClass) {
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, null, rootBeanClass, null, null, null);
        }

        public <T> ValidationContext<T> forValidateParameters(ParameterNameProvider parameterNameProvider, T rootBean, ExecutableElement executable, Object[] executableParameters) {
            Class<?> rootBeanClass = rootBean != null ? rootBean.getClass() : executable.getMember().getDeclaringClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, parameterNameProvider, this.failFast, rootBean, rootBeanClass, executable, executableParameters, null);
        }

        public <T> ValidationContext<T> forValidateReturnValue(T rootBean, ExecutableElement executable, Object executableReturnValue) {
            Class<?> rootBeanClass = rootBean != null ? rootBean.getClass() : executable.getMember().getDeclaringClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, rootBean, rootBeanClass, executable, null, executableReturnValue);
        }
    }
}

