/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.glassfish.web.deployment.descriptor.JspGroupDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JspGroupNode
extends DeploymentDescriptorNode<JspGroupDescriptor> {
    private JspGroupDescriptor descriptor;

    public JspGroupNode() {
        this.registerElementHandler(new XMLElement("display-name"), LocalizedInfoNode.class);
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("url-pattern", "addUrlPattern");
        table.put("display-name", "setDisplayName");
        table.put("el-ignored", "setElIgnored");
        table.put("page-encoding", "setPageEncoding");
        table.put("scripting-invalid", "setScriptingInvalid");
        table.put("include-prelude", "addIncludePrelude");
        table.put("include-coda", "addIncludeCoda");
        table.put("is-xml", "setIsXml");
        table.put("deferred-syntax-allowed-as-literal", "setDeferredSyntaxAllowedAsLiteral");
        table.put("trim-directive-whitespaces", "setTrimDirectiveWhitespaces");
        table.put("default-content-type", "setDefaultContentType");
        table.put("buffer", "setBuffer");
        table.put("error-on-undeclared-namespace", "setErrorOnUndeclaredNamespace");
        return table;
    }

    @Override
    public JspGroupDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new JspGroupDescriptor();
        }
        return this.descriptor;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, JspGroupDescriptor descriptor) {
        Element myNode = JspGroupNode.appendChild(parent, nodeName);
        LocalizedInfoNode localizedNode = new LocalizedInfoNode();
        this.writeLocalizedDescriptions(myNode, descriptor);
        localizedNode.writeLocalizedMap(myNode, "display-name", descriptor.getLocalizedDisplayNames());
        for (String urlPattern : descriptor.getUrlPatterns()) {
            JspGroupNode.appendTextChild((Node)myNode, "url-pattern", urlPattern);
        }
        JspGroupNode.appendTextChild((Node)myNode, "el-ignored", descriptor.getElIgnored());
        JspGroupNode.appendTextChild((Node)myNode, "page-encoding", descriptor.getPageEncoding());
        JspGroupNode.appendTextChild((Node)myNode, "scripting-invalid", descriptor.getScriptingInvalid());
        JspGroupNode.appendTextChild((Node)myNode, "is-xml", descriptor.getIsXml());
        for (String includePrelude : descriptor.getIncludePreludes()) {
            JspGroupNode.appendTextChild((Node)myNode, "include-prelude", includePrelude);
        }
        for (String includeCoda : descriptor.getIncludeCodas()) {
            JspGroupNode.appendTextChild((Node)myNode, "include-coda", includeCoda);
        }
        JspGroupNode.appendTextChild((Node)myNode, "deferred-syntax-allowed-as-literal", descriptor.getDeferredSyntaxAllowedAsLiteral());
        JspGroupNode.appendTextChild((Node)myNode, "trim-directive-whitespaces", descriptor.getTrimDirectiveWhitespaces());
        JspGroupNode.appendTextChild((Node)myNode, "default-content-type", descriptor.getDefaultContentType());
        JspGroupNode.appendTextChild((Node)myNode, "buffer", descriptor.getBuffer());
        JspGroupNode.appendTextChild((Node)myNode, "error-on-undeclared-namespace", descriptor.getErrorOnUndeclaredNamespace());
        return myNode;
    }
}

