/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.glassfish.security.services.api.authentication.ImpersonationService;
import org.glassfish.security.services.common.Secure;
import org.jvnet.hk2.annotations.Service;

@Service(name="impersonationService")
@Singleton
@Secure(accessPermissionName="security/service/impersonation/simple")
public class ImpersonationServiceImpl
implements ImpersonationService {
    static final Logger LOG = Logger.getLogger(ImpersonationServiceImpl.class.getName());

    @Override
    public Subject impersonate(String user, String[] groups, Subject subject, boolean virtual) throws LoginException {
        Subject _subject;
        Subject subject2 = _subject = subject != null ? subject : new Subject();
        if (user == null || user.isEmpty()) {
            return _subject;
        }
        if (!virtual) {
            throw new UnsupportedOperationException("Use of non-virtual parameter is not supported");
        }
        Set<Principal> principals = _subject.getPrincipals();
        principals.add(new PrincipalImpl(user));
        if (groups != null) {
            for (String group2 : groups) {
                principals.add(new Group(group2));
            }
        }
        return _subject;
    }
}

