/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.javamail.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.javamail.admin.cli.JavaMailResourceManager;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="create-javamail-resource", description="create-javamail-resource")})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-javamail-resource")
@PerLookup
@I18n(value="create.javamail.resource")
public class CreateJavaMailResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJavaMailResource.class);
    @Param(name="mailhost", alias="host")
    private String mailHost;
    @Param(name="mailuser", alias="user")
    private String mailUser;
    @Param(name="fromaddress", alias="from")
    private String fromAddress;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Param(name="storeprotocol", optional=true, defaultValue="imap", alias="storeProtocol")
    private String storeProtocol;
    @Param(name="storeprotocolclass", optional=true, defaultValue="com.sun.mail.imap.IMAPStore", alias="storeProtocolClass")
    private String storeProtocolClass;
    @Param(name="transprotocol", optional=true, defaultValue="smtp", alias="transportProtocol")
    private String transportProtocol;
    @Param(name="transprotocolclass", optional=true, defaultValue="com.sun.mail.smtp.SMTPTransport", alias="transportProtocolClass")
    private String transportProtocolClass;
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true, defaultValue="false")
    private Boolean debug;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(optional=true)
    private String description;
    @Inject
    private Domain domain;
    @Inject
    private JavaMailResourceManager mailResMgr;

    @Override
    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("jndi-name", this.jndiName);
        attributes.put("host", this.mailHost);
        attributes.put("user", this.mailUser);
        attributes.put("from", this.fromAddress);
        attributes.put("store-protocol", this.storeProtocol);
        attributes.put("store-protocol-class", this.storeProtocolClass);
        attributes.put("transport-protocol", this.transportProtocol);
        attributes.put("transport-protocol-class", this.transportProtocolClass);
        attributes.put("debug", this.debug.toString());
        attributes.put("enabled", this.enabled.toString());
        attributes.put("description", this.description);
        try {
            rs = this.mailResMgr.create(this.domain.getResources(), attributes, this.properties, this.target);
        }
        catch (Exception e) {
            Logger.getLogger(CreateJavaMailResource.class.getName()).log(Level.SEVERE, "Unable to create Mail Resource " + this.jndiName, e);
            String def = "Mail resource: {0} could not be created";
            report.setMessage(localStrings.getLocalString("create.mail.resource.fail", def, this.jndiName) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() == null) {
                report.setMessage(localStrings.getLocalString("create.mail.resource.fail", "Unable to create Mail Resource {0}.", this.jndiName));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        report.setActionExitCode(ec);
    }
}

