/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class CodeGeneratorUtil {
    public static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    public static final String STATIC_INITIALIZER_METHOD_NAME = "<clinit>";
    private static final Method defineClassMethod = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Method meth = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                meth.setAccessible(true);
                return meth;
            }
            catch (Exception exc) {
                throw new RuntimeException("Could not find defineClass method!", exc);
            }
        }
    });
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");

    private CodeGeneratorUtil() {
    }

    public static Class<?> makeClass(String name, byte[] def, ProtectionDomain pd, ClassLoader loader) {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(accessControlPermission);
        }
        try {
            return (Class)defineClassMethod.invoke((Object)loader, name, def, 0, def.length, pd);
        }
        catch (Exception exc) {
            throw new RuntimeException("Could not invoke defineClass!", exc);
        }
    }
}

