/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.MessageUtils;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import org.jvnet.mimepull.MIMEParsingException;

final class FormDataParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    private static final Logger LOGGER = Logger.getLogger(FormDataParamValueFactoryProvider.class.getName());
    private static final Set<Class<?>> TYPES = FormDataParamValueFactoryProvider.initializeTypes();

    private static Set<Class<?>> initializeTypes() {
        HashSet newSet = new HashSet();
        newSet.add(Byte.class);
        newSet.add(Byte.TYPE);
        newSet.add(Short.class);
        newSet.add(Short.TYPE);
        newSet.add(Integer.class);
        newSet.add(Integer.TYPE);
        newSet.add(Long.class);
        newSet.add(Long.TYPE);
        newSet.add(Float.class);
        newSet.add(Float.TYPE);
        newSet.add(Double.class);
        newSet.add(Double.TYPE);
        newSet.add(Boolean.class);
        newSet.add(Boolean.TYPE);
        newSet.add(Character.class);
        newSet.add(Character.TYPE);
        return newSet;
    }

    private static boolean isPrimitiveType(Class<?> type2) {
        return TYPES.contains(type2);
    }

    @Inject
    public FormDataParamValueFactoryProvider(MultivaluedParameterExtractorProvider extractorProvider, ServiceLocator locator) {
        super(extractorProvider, locator, Parameter.Source.ENTITY, Parameter.Source.UNKNOWN);
    }

    @Override
    protected Factory<?> createValueFactory(Parameter parameter) {
        Class<?> rawType = parameter.getRawType();
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (FormDataMultiPart.class.isAssignableFrom(rawType)) {
                return new FormDataMultiPartFactory();
            }
            return null;
        }
        if (parameter.getSourceAnnotation().annotationType() == FormDataParam.class) {
            String paramName = parameter.getSourceName();
            if (paramName == null || paramName.isEmpty()) {
                return null;
            }
            if (Collection.class == rawType || List.class == rawType) {
                Class<?> clazz = ReflectionHelper.getGenericTypeArgumentClasses(parameter.getType()).get(0);
                if (FormDataBodyPart.class == clazz) {
                    return new ListFormDataBodyPartValueFactory(paramName);
                }
                if (FormDataContentDisposition.class == clazz) {
                    return new ListFormDataContentDispositionFactory(paramName);
                }
                return new FormDataParamValueFactory(parameter, this.get(parameter));
            }
            if (FormDataBodyPart.class == rawType) {
                return new FormDataBodyPartFactory(paramName);
            }
            if (FormDataContentDisposition.class == rawType) {
                return new FormDataContentDispositionFactory(paramName);
            }
            if (File.class == rawType) {
                return new FileFactory(paramName);
            }
            return new FormDataParamValueFactory(parameter, this.get(parameter));
        }
        return null;
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.HIGH;
    }

    private final class FormDataParamValueFactory
    extends ValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final Parameter parameter;

        public FormDataParamValueFactory(Parameter parameter, MultivaluedParameterExtractor<?> extractor) {
            this.parameter = parameter;
            this.extractor = extractor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object provide() {
            List<FormDataBodyPart> parts = this.getEntity().getFields(this.parameter.getSourceName());
            FormDataBodyPart part = parts != null ? parts.get(0) : null;
            MediaType mediaType = part != null ? part.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
            ContainerRequest request = this.getContainerRequest();
            MessageBodyWorkers messageBodyWorkers = request.getWorkers();
            MessageBodyReader<?> messageBodyReader = messageBodyWorkers.getMessageBodyReader(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType);
            if (messageBodyReader != null && !FormDataParamValueFactoryProvider.isPrimitiveType(this.parameter.getRawType())) {
                InputStream stream;
                if (part == null) {
                    if (this.parameter.getDefaultValue() == null) return null;
                    stream = new ByteArrayInputStream(this.parameter.getDefaultValue().getBytes(MessageUtils.getCharset(mediaType)));
                } else {
                    stream = part.getEntityAs(BodyPartEntity.class).getInputStream();
                }
                try {
                    return messageBodyReader.readFrom(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType, request.getHeaders(), stream);
                }
                catch (IOException e) {
                    throw new FormDataParamException(e, this.parameter.getSourceName(), this.parameter.getDefaultValue());
                }
            }
            if (this.extractor == null) return null;
            MultivaluedStringMap map = new MultivaluedStringMap();
            try {
                if (part == null) return this.extractor.extract(map);
                for (FormDataBodyPart p : parts) {
                    MessageBodyReader<String> messageBodyReader2 = messageBodyWorkers.getMessageBodyReader(String.class, (Type)((Object)String.class), this.parameter.getAnnotations(), p.getMediaType());
                    String value = messageBodyReader2.readFrom(String.class, (Type)((Object)String.class), this.parameter.getAnnotations(), mediaType, request.getHeaders(), ((BodyPartEntity)p.getEntity()).getInputStream());
                    map.add(this.parameter.getSourceName(), value);
                }
                return this.extractor.extract(map);
            }
            catch (IOException | ExtractorException ex) {
                throw new FormDataParamException(ex, this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    private final class FileFactory
    extends ValueFactory<File> {
        private final String name;

        public FileFactory(String name) {
            this.name = name;
        }

        @Override
        public File provide() {
            BodyPartEntity entity;
            FormDataBodyPart part = this.getEntity().getField(this.name);
            BodyPartEntity bodyPartEntity = entity = part != null ? part.getEntityAs(BodyPartEntity.class) : null;
            if (entity != null) {
                try {
                    File file = Utils.createTempFile();
                    entity.moveTo(file);
                    return file;
                }
                catch (IOException | MIMEParsingException cannotMove) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.CANNOT_INJECT_FILE(), cannotMove);
                }
            }
            return null;
        }
    }

    private final class FormDataContentDispositionFactory
    extends ValueFactory<FormDataContentDisposition> {
        private final String name;

        public FormDataContentDispositionFactory(String name) {
            this.name = name;
        }

        @Override
        public FormDataContentDisposition provide() {
            FormDataBodyPart part = this.getEntity().getField(this.name);
            return part == null ? null : part.getFormDataContentDisposition();
        }
    }

    private final class FormDataBodyPartFactory
    extends ValueFactory<FormDataBodyPart> {
        private final String name;

        public FormDataBodyPartFactory(String name) {
            this.name = name;
        }

        @Override
        public FormDataBodyPart provide() {
            return this.getEntity().getField(this.name);
        }
    }

    private final class ListFormDataContentDispositionFactory
    extends ValueFactory<List<FormDataContentDisposition>> {
        private final String name;

        public ListFormDataContentDispositionFactory(String name) {
            this.name = name;
        }

        @Override
        public List<FormDataContentDisposition> provide() {
            List<FormDataBodyPart> parts = this.getEntity().getFields(this.name);
            return parts == null ? null : Lists.transform(parts, new Function<FormDataBodyPart, FormDataContentDisposition>(){

                @Override
                public FormDataContentDisposition apply(FormDataBodyPart part) {
                    return part.getFormDataContentDisposition();
                }
            });
        }
    }

    private final class ListFormDataBodyPartValueFactory
    extends ValueFactory<List<FormDataBodyPart>> {
        private final String name;

        public ListFormDataBodyPartValueFactory(String name) {
            this.name = name;
        }

        @Override
        public List<FormDataBodyPart> provide() {
            return this.getEntity().getFields(this.name);
        }
    }

    private final class FormDataMultiPartFactory
    extends ValueFactory<FormDataMultiPart> {
        private FormDataMultiPartFactory() {
        }

        @Override
        public FormDataMultiPart provide() {
            return this.getEntity();
        }
    }

    private abstract class ValueFactory<T>
    extends AbstractContainerRequestValueFactory<T> {
        private ValueFactory() {
        }

        FormDataMultiPart getEntity() {
            String requestPropertyName;
            ContainerRequest request = this.getContainerRequest();
            if (request.getProperty(requestPropertyName = FormDataMultiPart.class.getName()) == null) {
                request.setProperty(requestPropertyName, request.readEntity(FormDataMultiPart.class));
            }
            return (FormDataMultiPart)request.getProperty(requestPropertyName);
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<FormDataParam> {
        public InjectionResolver() {
            super(FormDataParamValueFactoryProvider.class);
        }
    }

    private static final class FormDataParamException
    extends ParamException {
        protected FormDataParamException(Throwable cause, String name, String defaultStringValue) {
            super(cause, Response.Status.BAD_REQUEST, FormDataParam.class, name, defaultStringValue);
        }
    }
}

