/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.jersey.jettison.internal.LocalizationMessages;
import org.glassfish.jersey.jettison.internal.entity.JettisonLowLevelProvider;

public class JettisonArrayProvider
extends JettisonLowLevelProvider<JSONArray> {
    JettisonArrayProvider() {
        super(JSONArray.class);
    }

    @Override
    public JSONArray readFrom(Class<JSONArray> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return new JSONArray(JettisonArrayProvider.readFromAsString(entityStream, mediaType));
        }
        catch (JSONException je) {
            throw new WebApplicationException((Throwable)new Exception(LocalizationMessages.ERROR_PARSING_JSON_ARRAY(), je), 400);
        }
    }

    @Override
    public void writeTo(JSONArray t, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream, JettisonArrayProvider.getCharset(mediaType));
            t.write(writer);
            writer.write("\n");
            writer.flush();
        }
        catch (JSONException je) {
            throw new WebApplicationException((Throwable)new Exception(LocalizationMessages.ERROR_WRITING_JSON_ARRAY(), je), 500);
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JettisonArrayProvider {
        @Override
        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JettisonArrayProvider {
    }
}

