/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.jersey.gf.ejb.internal.EjbComponentInterceptor;
import org.glassfish.jersey.gf.ejb.internal.EjbExceptionMapper;
import org.glassfish.jersey.gf.ejb.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

@Priority(value=300)
public final class EjbComponentProvider
implements ComponentProvider,
ResourceMethodInvocationHandlerProvider {
    private static final Logger LOGGER = Logger.getLogger(EjbComponentProvider.class.getName());
    private InitialContext initialContext;
    private final List<String> libNames = new CopyOnWriteArrayList<String>();
    private boolean ejbInterceptorRegistered = false;
    private static final Set<String> EjbComponentAnnotations = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("javax.ejb.Stateful");
            this.add("javax.ejb.Stateless");
            this.add("javax.ejb.Singleton");
        }
    });
    private ServiceLocator locator = null;

    @Override
    public void initialize(ServiceLocator locator) {
        this.locator = locator;
        DynamicConfiguration configuration = Injections.getConfiguration(locator);
        Injections.addBinding(Injections.newBinder(this).to(ResourceMethodInvocationHandlerProvider.class), configuration);
        configuration.commit();
    }

    private ApplicationInfo getApplicationInfo(EjbContainerUtil ejbUtil) throws NamingException {
        ApplicationRegistry appRegistry = ejbUtil.getServices().getService(ApplicationRegistry.class, new Annotation[0]);
        Applications applications = ejbUtil.getServices().getService(Applications.class, new Annotation[0]);
        String appNamePrefix = (String)this.initialContext.lookup("java:app/AppName");
        Set<String> appNames = appRegistry.getAllApplicationNames();
        TreeSet<String> disabledApps = new TreeSet<String>();
        for (String appName : appNames) {
            if (!appName.startsWith(appNamePrefix)) continue;
            Application appDesc = applications.getApplication(appName);
            if (appDesc != null && !ejbUtil.getDeployment().isAppEnabled(appDesc)) {
                disabledApps.add(appName);
                continue;
            }
            return ejbUtil.getDeployment().get(appName);
        }
        Iterator it = disabledApps.iterator();
        String lastDisabledApp = null;
        while (it.hasNext()) {
            lastDisabledApp = (String)it.next();
        }
        if (lastDisabledApp != null) {
            return ejbUtil.getDeployment().get(lastDisabledApp);
        }
        throw new NamingException("Application Information Not Found");
    }

    private void registerEjbInterceptor() {
        try {
            final EjbComponentInterceptor interceptor = new EjbComponentInterceptor(this.locator);
            this.initialContext = EjbComponentProvider.getInitialContext();
            EjbContainerUtil ejbUtil = EjbContainerUtilImpl.getInstance();
            ApplicationInfo appInfo = this.getApplicationInfo(ejbUtil);
            LinkedList<String> tempLibNames = new LinkedList<String>();
            for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
                String jarName = moduleInfo.getName();
                if (!jarName.endsWith(".jar")) continue;
                String moduleName = jarName.substring(0, jarName.length() - 4);
                tempLibNames.add(moduleName);
                Object bundleDescriptor = moduleInfo.getMetaData(EjbBundleDescriptorImpl.class.getName());
                if (!(bundleDescriptor instanceof EjbBundleDescriptorImpl)) continue;
                Set<EjbDescriptor> ejbs = ((EjbBundleDescriptorImpl)bundleDescriptor).getEjbs();
                for (EjbDescriptor ejb : ejbs) {
                    final BaseContainer ejbContainer = EjbContainerUtilImpl.getInstance().getContainer(ejb.getUniqueId());
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Method registerInterceptorMethod = BaseContainer.class.getDeclaredMethod("registerSystemInterceptor", Object.class);
                                registerInterceptorMethod.setAccessible(true);
                                registerInterceptorMethod.invoke((Object)ejbContainer, interceptor);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        LOGGER.log(Level.WARNING, LocalizationMessages.EJB_INTERCEPTOR_BINDING_WARNING(ejb.getEjbClassName()), cause);
                    }
                }
            }
            this.libNames.addAll(tempLibNames);
            final Object interceptorBinder = this.initialContext.lookup("java:org.glassfish.ejb.container.interceptor_binding_spi");
            if (interceptorBinder == null) {
                throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NOT_AVAILABLE());
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Method interceptorBinderMethod = interceptorBinder.getClass().getMethod("registerInterceptor", Object.class);
                        interceptorBinderMethod.invoke(interceptorBinder, interceptor);
                        EjbComponentProvider.this.ejbInterceptorRegistered = true;
                        LOGGER.log(Level.CONFIG, LocalizationMessages.EJB_INTERCEPTOR_BOUND());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_ERROR(), pae.getCause());
            }
        }
        catch (NamingException ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NOT_AVAILABLE(), ex);
        }
        catch (LinkageError ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_LINKAGE_ERROR(), ex);
        }
    }

    @Override
    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.EJB_CLASS_BEING_CHECKED(component));
        }
        if (this.locator == null) {
            throw new IllegalStateException(LocalizationMessages.EJB_COMPONENT_PROVIDER_NOT_INITIALIZED_PROPERLY());
        }
        if (!this.isEjbComponent(component)) {
            return false;
        }
        if (!this.ejbInterceptorRegistered) {
            this.registerEjbInterceptor();
        }
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        ServiceBindingBuilder<?> bindingBuilder = Injections.newFactoryBinder(new EjbFactory(component, this.initialContext, this));
        bindingBuilder.to(component);
        for (Class<?> contract : providerContracts) {
            bindingBuilder.to(contract);
        }
        Injections.addBinding(bindingBuilder, dc);
        dc.commit();
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.EJB_CLASS_BOUND_WITH_CDI(component));
        }
        return true;
    }

    @Override
    public void done() {
        this.registerEjbExceptionMapper();
    }

    private void registerEjbExceptionMapper() {
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        Injections.addBinding(Injections.newBinder(EjbExceptionMapper.class).to(ExceptionMapper.class).in(Singleton.class), dc);
        dc.commit();
    }

    private boolean isEjbComponent(Class<?> component) {
        for (Annotation a : component.getAnnotations()) {
            if (!EjbComponentAnnotations.contains(a.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InvocationHandler create(Invocable method) {
        Class<?> resourceClass = method.getHandler().getHandlerClass();
        if (resourceClass == null || !this.isEjbComponent(resourceClass)) {
            return null;
        }
        Method handlingMethod = method.getDefinitionMethod();
        for (Class iFace : this.remoteAndLocalIfaces(resourceClass)) {
            try {
                final Method iFaceMethod = iFace.getDeclaredMethod(handlingMethod.getName(), handlingMethod.getParameterTypes());
                if (iFaceMethod == null) continue;
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object target, Method ignored, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        return iFaceMethod.invoke(target, args);
                    }
                };
            }
            catch (NoSuchMethodException | SecurityException ex) {
                this.logLookupException(handlingMethod, resourceClass, iFace, ex);
            }
        }
        return null;
    }

    private void logLookupException(Method method, Class<?> component, Class<?> iFace, Exception ex) {
        LOGGER.log(Level.WARNING, LocalizationMessages.EJB_INTERFACE_HANDLING_METHOD_LOOKUP_EXCEPTION(method, component, iFace), ex);
    }

    private List<Class> remoteAndLocalIfaces(Class<?> resourceClass) {
        LinkedList<Class> allLocalOrRemoteIfaces = new LinkedList<Class>();
        if (resourceClass.isAnnotationPresent(Remote.class)) {
            allLocalOrRemoteIfaces.addAll(Arrays.asList(resourceClass.getAnnotation(Remote.class).value()));
        }
        if (resourceClass.isAnnotationPresent(Local.class)) {
            allLocalOrRemoteIfaces.addAll(Arrays.asList(resourceClass.getAnnotation(Local.class).value()));
        }
        for (Class<?> i : resourceClass.getInterfaces()) {
            if (!i.isAnnotationPresent(Remote.class) && !i.isAnnotationPresent(Local.class)) continue;
            allLocalOrRemoteIfaces.add(i);
        }
        return allLocalOrRemoteIfaces;
    }

    private static InitialContext getInitialContext() {
        try {
            return new InitialContext();
        }
        catch (Exception ex) {
            throw new IllegalStateException(LocalizationMessages.INITIAL_CONTEXT_NOT_AVAILABLE(), ex);
        }
    }

    private static Object lookup(InitialContext ic, Class<?> c, String name, EjbComponentProvider provider) throws NamingException {
        try {
            return EjbComponentProvider.lookupSimpleForm(ic, name, provider);
        }
        catch (NamingException ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.EJB_CLASS_SIMPLE_LOOKUP_FAILED(c.getName()), ex);
            return EjbComponentProvider.lookupFullyQualifiedForm(ic, c, name, provider);
        }
    }

    private static Object lookupSimpleForm(InitialContext ic, String name, EjbComponentProvider provider) throws NamingException {
        if (provider.libNames.isEmpty()) {
            String jndiName = "java:module/" + name;
            return ic.lookup(jndiName);
        }
        NamingException ne = null;
        for (String moduleName : provider.libNames) {
            String jndiName = "java:app/" + moduleName + "/" + name;
            try {
                Object result = ic.lookup(jndiName);
                if (result == null) continue;
                return result;
            }
            catch (NamingException e) {
                ne = e;
            }
        }
        throw ne != null ? ne : new NamingException();
    }

    private static Object lookupFullyQualifiedForm(InitialContext ic, Class<?> c, String name, EjbComponentProvider provider) throws NamingException {
        if (provider.libNames.isEmpty()) {
            String jndiName = "java:module/" + name + "!" + c.getName();
            return ic.lookup(jndiName);
        }
        NamingException ne = null;
        for (String moduleName : provider.libNames) {
            String jndiName = "java:app/" + moduleName + "/" + name + "!" + c.getName();
            try {
                Object result = ic.lookup(jndiName);
                if (result == null) continue;
                return result;
            }
            catch (NamingException e) {
                ne = e;
            }
        }
        throw ne != null ? ne : new NamingException();
    }

    private static class EjbFactory<T>
    implements Factory<T> {
        final InitialContext ctx;
        final Class<T> clazz;
        final EjbComponentProvider ejbProvider;

        @Override
        public T provide() {
            try {
                return (T)EjbComponentProvider.lookup(this.ctx, this.clazz, this.clazz.getSimpleName(), this.ejbProvider);
            }
            catch (NamingException ex) {
                Logger.getLogger(ApplicationHandler.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        @Override
        public void dispose(T instance) {
        }

        public EjbFactory(Class<T> rawType, InitialContext ctx, EjbComponentProvider ejbProvider) {
            this.clazz = rawType;
            this.ctx = ctx;
            this.ejbProvider = ejbProvider;
        }
    }
}

