/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class EngineInfo<T extends Container, U extends ApplicationContainer> {
    final ServiceHandle<T> container;
    final Sniffer sniffer;
    ContainerRegistry registry = null;
    Deployer deployer;

    public EngineInfo(ServiceHandle<T> container, Sniffer sniffer, ClassLoader cloader) {
        this.container = container;
        this.sniffer = sniffer;
    }

    public T getContainer() {
        return (T)((Container)this.container.getService());
    }

    public Sniffer getSniffer() {
        return this.sniffer;
    }

    public Deployer<T, U> getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer<T, U> deployer) {
        this.deployer = deployer;
    }

    public void load(ExtendedDeploymentContext context) {
    }

    public void unload(ExtendedDeploymentContext context) throws Exception {
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        this.getDeployer().clean(context);
    }

    public void setRegistry(ContainerRegistry registry) {
        this.registry = registry;
    }

    public void stop(Logger logger2) {
        ServiceHandle<?> i;
        if (this.getDeployer() != null && (i = this.registry.habitat.getServiceHandle(this.getDeployer().getClass(), new Annotation[0])) != null) {
            i.destroy();
        }
        if (this.container != null && this.container.isActive()) {
            this.container.destroy();
        }
        this.registry.removeContainer(this);
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine("Container " + this.getContainer().getName() + " stopped");
        }
    }
}

