/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.utilities.DescriptorImpl;

public class ApplicationClassLoadingPostProcessor
implements PopulatorPostProcessor {
    private final HK2Loader applicationLoader;

    ApplicationClassLoadingPostProcessor(final ClassLoader appClassLoader) {
        this.applicationLoader = new HK2Loader(){

            @Override
            public Class<?> loadClass(String className) throws MultiException {
                try {
                    return appClassLoader.loadClass(className);
                }
                catch (Throwable th) {
                    throw new MultiException(th);
                }
            }
        };
    }

    @Override
    public DescriptorImpl process(ServiceLocator serviceLocator, DescriptorImpl descriptorImpl) {
        if (descriptorImpl.getLoader() != null) {
            return descriptorImpl;
        }
        descriptorImpl.setLoader(this.applicationLoader);
        return descriptorImpl;
    }
}

