/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.factory;

import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public final class EJBSecurityManagerFactory
extends SecurityManagerFactory {
    private static Logger _logger = null;
    @Inject
    InvocationManager invMgr;
    @Inject
    AppServerAuditManager auditManager;
    private EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();
    private Map<String, ArrayList<String>> CONTEXT_IDS = new HashMap<String, ArrayList<String>>();
    private Map<String, Map<String, EJBSecurityManager>> SECURITY_MANAGERS = new HashMap<String, Map<String, EJBSecurityManager>>();

    public <T> EJBSecurityManager getManager(String ctxId, String name, boolean remove) {
        return (EJBSecurityManager)this.getManager(this.SECURITY_MANAGERS, ctxId, name, remove);
    }

    public <T> ArrayList<EJBSecurityManager> getManagers(String ctxId, boolean remove) {
        return this.getManagers(this.SECURITY_MANAGERS, ctxId, remove);
    }

    public <T> ArrayList<EJBSecurityManager> getManagersForApp(String appName, boolean remove) {
        return this.getManagersForApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, appName, remove);
    }

    public <T> String[] getContextsForApp(String appName, boolean remove) {
        return this.getContextsForApp(this.CONTEXT_IDS, appName, remove);
    }

    public <T> void addManagerToApp(String ctxId, String name, String appName, EJBSecurityManager manager) {
        this.addManagerToApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, ctxId, name, appName, manager);
    }

    public EJBSecurityManager createManager(EjbDescriptor ejbDesc, boolean register) {
        String ctxId = EJBSecurityManager.getContextID(ejbDesc);
        String ejbName = ejbDesc.getName();
        EJBSecurityManager manager = null;
        if (register) {
            manager = this.getManager(ctxId, ejbName, false);
        }
        if (manager == null || !register) {
            try {
                this.probeProvider.securityManagerCreationStartedEvent(ejbName);
                manager = new EJBSecurityManager(ejbDesc, this.invMgr, this);
                this.probeProvider.securityManagerCreationEndedEvent(ejbName);
                if (register) {
                    String appName = ejbDesc.getApplication().getRegistrationName();
                    this.addManagerToApp(ctxId, ejbName, appName, manager);
                    this.probeProvider.securityManagerCreationEvent(ejbName);
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "[EJB-Security] FATAL Exception. Unable to create EJBSecurityManager: " + ex.getMessage());
                throw new RuntimeException(ex);
            }
        }
        return manager;
    }

    public final AppServerAuditManager getAuditManager() {
        return this.auditManager;
    }

    static {
        _logger = LogDomains.getLogger(EJBSecurityManagerFactory.class, "javax.enterprise.system.core.security");
    }
}

