/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.ejb.BeforeCompletion;
import javax.ejb.Stateful;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=BeforeCompletion.class)
public class BeforeCompletionHandler
extends AbstractAttributeHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        for (EjbContext ejbContext : ejbContexts) {
            EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)ejbContext.getDescriptor();
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            this.checkValid(annMethod);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Setting BeforeCompletion method " + annMethod);
            }
            ejbDesc.setBeforeCompletionMethodIfNotSet(new MethodDescriptor(annMethod));
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Stateful.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    private void checkValid(Method m) throws AnnotationProcessorException {
        if (!m.getReturnType().equals(Void.TYPE) || m.getParameterTypes().length != 0) {
            throw new AnnotationProcessorException("Method " + m + "annotated as @BeforeCompletion is not valid");
        }
    }
}

