/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.ejb.Asynchronous;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=Asynchronous.class)
public class AsynchronousHandler
extends AbstractAttributeHandler
implements PostProcessor<EjbContext> {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = (EjbDescriptor)ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            this.setAsynchronous(annMethod, ejbDesc);
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Local.class, Remote.class, Stateful.class, Stateless.class, Singleton.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, EjbContext ejbContext) throws AnnotationProcessorException {
        Method[] methods;
        EjbDescriptor ejbDesc = (EjbDescriptor)ejbContext.getDescriptor();
        Class classAn = (Class)ainfo.getAnnotatedElement();
        for (Method m0 : methods = classAn.getDeclaredMethods()) {
            this.setAsynchronous(m0, ejbDesc);
        }
    }

    private void setAsynchronous(Method m0, EjbDescriptor ejbDesc) throws AnnotationProcessorException {
        this.setAsynchronous(m0, ejbDesc, null);
    }

    private void setAsynchronous(Method m0, EjbDescriptor ejbDesc, String methodIntf) throws AnnotationProcessorException {
        MethodDescriptor methodDesc;
        if (!ejbDesc.getType().equals("Session")) {
            throw new AnnotationProcessorException("Invalid asynchronous method " + m0 + "@Asynchronous is only permitted for session beans");
        }
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
        MethodDescriptor methodDescriptor = methodDesc = methodIntf == null ? new MethodDescriptor(m0) : new MethodDescriptor(m0, methodIntf);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Adding asynchronous method " + methodDesc);
        }
        sessionDesc.addAsynchronousMethod(methodDesc);
    }
}

