/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.deployment.versioning.VersioningWildcardException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-application-ref")
@I18n(value="create.application.ref.command")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="create-application-ref"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="create-application-ref")})
public class CreateApplicationRefCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(optional=true, acceptableValues="true,false")
    public String lbenabled;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    VersioningService versioningService;
    @Inject
    @Named(value="default-instance-name")
    protected Server server;
    @Inject
    private ServiceLocator habitat;
    @Inject
    Events events;

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList accessChecks = new ArrayList();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target), "create"));
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        List<String> matchedVersions = null;
        if (this.enabled.booleanValue()) {
            try {
                VersioningUtils.checkIdentifier(this.name);
                matchedVersions = new ArrayList<String>(1);
                matchedVersions.add(this.name);
            }
            catch (VersioningWildcardException ex) {
                report.setMessage(localStrings.getLocalString("wildcard.not.allowed", "WARNING : version expression are available only with --enabled=false"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            catch (VersioningSyntaxException ex) {
                report.setMessage(ex.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.deployment.isRegistered(this.name)) {
                report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", this.name));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            try {
                matchedVersions = this.versioningService.getMatchedVersions(this.name, null);
            }
            catch (VersioningException e) {
                report.failure(logger2, e.getMessage());
                return;
            }
            if (matchedVersions.isEmpty()) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        boolean isVersionExpression = VersioningUtils.isVersionExpression(this.name);
        for (String appName : matchedVersions) {
            ReadableArchive archive;
            Properties contextProps;
            Application app = this.applications.getApplication(appName);
            ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(appName, this.target);
            if (applicationRef != null) {
                if (isVersionExpression) {
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", appName, this.target));
                    continue;
                }
                report.setMessage(localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", this.name, this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Transaction t = new Transaction();
            if (app.isLifecycleModule()) {
                this.handleLifecycleModule(context, t);
                return;
            }
            File file = null;
            DeployCommandParameters commandParams = null;
            Map<String, Properties> modulePropsMap = null;
            ApplicationConfigInfo savedAppConfig = null;
            try {
                commandParams = app.getDeployParameters(null);
                commandParams.origin = OpsParams.Origin.create_application_ref;
                commandParams.command = OpsParams.Command.create_application_ref;
                commandParams.target = this.target;
                commandParams.virtualservers = this.virtualservers;
                commandParams.enabled = this.enabled;
                if (this.lbenabled != null) {
                    commandParams.lbenabled = this.lbenabled;
                }
                commandParams.type = app.archiveType();
                contextProps = app.getDeployProperties();
                modulePropsMap = app.getModulePropertiesMap();
                savedAppConfig = new ApplicationConfigInfo(app);
                URI uri = new URI(app.getLocation());
                file = new File(uri);
                if (!file.exists()) {
                    report.setMessage(localStrings.getLocalString("fnf", "File not found", file.getAbsolutePath()));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                archive = this.archiveFactory.openArchive(file);
            }
            catch (Exception e) {
                logger2.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                report.setMessage(localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                String runtimeAltDDLocation;
                String altDDLocation;
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger2, commandParams, report).source(archive).build();
                Properties appProps = deploymentContext.getAppProps();
                appProps.putAll((Map<?, ?>)contextProps);
                String location = DeploymentUtils.relativizeWithinDomainIfPossible(new URI(app.getLocation()));
                appProps.setProperty("location", location);
                String appLocation = appProps.getProperty("appLocation");
                appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible(new URI(appLocation)));
                String planLocation = appProps.getProperty("deploymentPlanLocation");
                if (planLocation != null) {
                    appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible(new URI(planLocation)));
                }
                if ((altDDLocation = appProps.getProperty("altDDLocation")) != null) {
                    appProps.setProperty("altDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible(new URI(altDDLocation)));
                }
                if ((runtimeAltDDLocation = appProps.getProperty("runtimeAltDDLocation")) != null) {
                    appProps.setProperty("runtimeAltDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible(new URI(runtimeAltDDLocation)));
                }
                savedAppConfig.store(appProps);
                if (modulePropsMap != null) {
                    deploymentContext.setModulePropsMap(modulePropsMap);
                }
                if (this.enabled.booleanValue()) {
                    this.versioningService.handleDisable(appName, this.target, deploymentContext.getActionReport(), context.getSubject());
                }
                if (this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null)) {
                    this.deployment.deploy(this.deployment.getSniffersFromApp(app), deploymentContext);
                } else {
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_PREPARED, deploymentContext), false);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    try {
                        this.deployment.registerAppInDomainXML(null, deploymentContext, t, true);
                    }
                    catch (TransactionFailure e) {
                        logger2.warning("failed to create application ref for " + appName);
                    }
                }
                if (!isVersionExpression && DeploymentUtils.isDASTarget(this.target)) {
                    return;
                }
                ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap(deploymentContext);
                ArrayList<String> targets = new ArrayList<String>(Arrays.asList(commandParams.target.split(",")));
                ClusterOperationUtil.replicateCommand("_deploy", FailurePolicy.Error, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, paramMap, this.habitat);
            }
            catch (Exception e) {
                logger2.log(Level.SEVERE, "Error during creating application ref ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            finally {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    logger2.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    private void handleLifecycleModule(AdminCommandContext context, Transaction t) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        Application app = this.applications.getApplication(this.name);
        DeployCommandParameters commandParams = new DeployCommandParameters();
        commandParams.name = this.name;
        commandParams.target = this.target;
        commandParams.virtualservers = this.virtualservers;
        commandParams.enabled = this.enabled;
        DeploymentContextImpl lifecycleContext = new DeploymentContextImpl(report, null, commandParams, null);
        try {
            this.deployment.registerAppInDomainXML(null, lifecycleContext, t, true);
        }
        catch (Exception e) {
            report.failure(logger2, e.getMessage());
        }
        if (!DeploymentUtils.isDASTarget(this.target)) {
            ParameterMap paramMap = new ParameterMap();
            paramMap.add("DEFAULT", this.name);
            paramMap.add("target", this.target);
            paramMap.add("enabled", this.enabled.toString());
            if (this.virtualservers != null) {
                paramMap.add("virtualservers", this.virtualservers);
            }
            Properties appProps = app.getDeployProperties();
            paramMap.set("appprops", DeploymentUtils.propertiesValue(appProps, ':'));
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(this.target);
            ClusterOperationUtil.replicateCommand("_lifecycle", FailurePolicy.Error, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, paramMap, this.habitat);
        }
    }
}

