/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.hk2.api.PerLookup;

@PerLookup
@I18n(value="create.connector.security.map")
public class ConnectorSecurityMap {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorSecurityMap.class);

    boolean doesPoolNameExist(String poolName, Collection<ConnectorConnectionPool> ccPools) {
        boolean doesPoolExist = false;
        if (ccPools != null) {
            for (ConnectorConnectionPool ccp : ccPools) {
                if (!ccp.getName().equals(poolName)) continue;
                doesPoolExist = true;
            }
        }
        return doesPoolExist;
    }

    boolean doesMapNameExist(String poolName, String mapname, Collection<ConnectorConnectionPool> ccPools) {
        List<SecurityMap> maps = this.getAllSecurityMapsForPool(poolName, ccPools);
        boolean doesMapNameExist = false;
        if (maps != null) {
            for (SecurityMap sm : maps) {
                String name = sm.getName();
                if (!name.equals(mapname)) continue;
                doesMapNameExist = true;
            }
        }
        return doesMapNameExist;
    }

    List<SecurityMap> getAllSecurityMapsForPool(String poolName, Collection<ConnectorConnectionPool> ccPools) {
        List<SecurityMap> securityMaps = null;
        for (ConnectorConnectionPool ccp : ccPools) {
            if (!ccp.getName().equals(poolName)) continue;
            securityMaps = ccp.getSecurityMap();
            break;
        }
        return securityMaps;
    }

    ConnectorConnectionPool getPool(String poolName, Collection<ConnectorConnectionPool> ccPools) {
        ConnectorConnectionPool pool = null;
        for (ConnectorConnectionPool ccp : ccPools) {
            if (!ccp.getName().equals(poolName)) continue;
            pool = ccp;
            break;
        }
        return pool;
    }

    SecurityMap getSecurityMap(String mapName, String poolName, Collection<ConnectorConnectionPool> ccPools) {
        List<SecurityMap> maps = this.getAllSecurityMapsForPool(poolName, ccPools);
        SecurityMap map = null;
        if (maps != null) {
            for (SecurityMap sm : maps) {
                if (!sm.getName().equals(mapName)) continue;
                map = sm;
                break;
            }
        }
        return map;
    }

    boolean isPrincipalExisting(String principal, List<SecurityMap> maps) {
        boolean exists = false;
        List<String> existingPrincipals = null;
        if (maps != null) {
            block0: for (SecurityMap sm : maps) {
                existingPrincipals = sm.getPrincipal();
                if (existingPrincipals == null || principal == null) continue;
                for (String ep : existingPrincipals) {
                    if (!ep.equals(principal)) continue;
                    exists = true;
                    continue block0;
                }
            }
        }
        return exists;
    }

    boolean isUserGroupExisting(String usergroup, List<SecurityMap> maps) {
        boolean exists = false;
        List<String> existingUserGroups = null;
        if (maps != null) {
            block0: for (SecurityMap sm : maps) {
                existingUserGroups = sm.getUserGroup();
                if (existingUserGroups == null || usergroup == null) continue;
                for (String eug : existingUserGroups) {
                    if (!eug.equals(usergroup)) continue;
                    exists = true;
                    continue block0;
                }
            }
        }
        return exists;
    }
}

