/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LogHelper {
    public static void log(Logger logger2, Level level, String messageId, Throwable thrown, Object ... params) {
        LogRecord rec = new LogRecord(level, messageId);
        rec.setLoggerName(logger2.getName());
        rec.setResourceBundleName(logger2.getResourceBundleName());
        rec.setResourceBundle(logger2.getResourceBundle());
        rec.setParameters(params);
        rec.setThrown(thrown);
        logger2.log(rec);
    }

    public static String getFormattedMessage(Logger logger2, String msgKey, Object ... params) {
        ResourceBundle rb = logger2.getResourceBundle();
        if (rb != null) {
            try {
                return MessageFormat.format(rb.getString(msgKey), params);
            }
            catch (MissingResourceException e) {
                return msgKey;
            }
        }
        return msgKey;
    }
}

