/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractSemanticValidator;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.EclipseLinkLiteralVisitor;
import org.eclipse.persistence.jpa.jpql.EclipseLinkSemanticValidatorExtension;
import org.eclipse.persistence.jpa.jpql.EclipseLinkVersion;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;

public class AbstractEclipseLinkSemanticValidator
extends AbstractSemanticValidator
implements EclipseLinkExpressionVisitor {
    private EclipseLinkSemanticValidatorExtension extension;
    private SubquerySelectItemCalculator subquerySelectItemCalculator;
    private TableExpressionVisitor tableExpressionVisitor;

    protected AbstractEclipseLinkSemanticValidator(SemanticValidatorHelper helper, EclipseLinkSemanticValidatorExtension extension) {
        super(helper);
        this.extension = extension;
    }

    @Override
    protected LiteralVisitor buildLiteralVisitor() {
        return new EclipseLinkLiteralVisitor();
    }

    @Override
    protected AbstractValidator.OwningClauseVisitor buildOwningClauseVisitor() {
        return new EclipseLinkOwningClauseVisitor();
    }

    protected SubquerySelectItemCalculator buildSubquerySelectItemCalculator() {
        return new SubquerySelectItemCalculator();
    }

    protected TableExpressionVisitor buildTableExpressionVisitor() {
        return new TableExpressionVisitor();
    }

    @Override
    protected TopLevelFirstDeclarationVisitor buildTopLevelFirstDeclarationVisitor() {
        return new TopLevelFirstDeclarationVisitor(this);
    }

    protected JPQLQueryDeclaration getDeclaration(String variableName) {
        for (JPQLQueryDeclaration declaration : this.helper.getAllDeclarations()) {
            if (!declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return declaration;
        }
        return null;
    }

    protected EclipseLinkSemanticValidatorExtension getExtension() {
        return this.extension;
    }

    protected SubquerySelectItemCalculator getSubquerySelectItemCalculator() {
        if (this.subquerySelectItemCalculator == null) {
            this.subquerySelectItemCalculator = this.buildSubquerySelectItemCalculator();
        }
        return this.subquerySelectItemCalculator;
    }

    protected TableExpressionVisitor getTableExpressionVisitor() {
        if (this.tableExpressionVisitor == null) {
            this.tableExpressionVisitor = this.buildTableExpressionVisitor();
        }
        return this.tableExpressionVisitor;
    }

    protected boolean isTableExpression(Expression expression) {
        TableExpressionVisitor visitor = this.getTableExpressionVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
            visitor.expression = null;
        }
    }

    @Override
    protected AbstractSemanticValidator.PathType selectClausePathExpressionPathType() {
        return AbstractSemanticValidator.PathType.ANY_FIELD_INCLUDING_COLLECTION;
    }

    protected int subquerySelectItemCount(Expression subquery) {
        SubquerySelectItemCalculator visitor = this.getSubquerySelectItemCalculator();
        try {
            visitor.count = 0;
            subquery.accept(visitor);
            int n = visitor.count;
            return n;
        }
        finally {
            visitor.count = 0;
        }
    }

    @Override
    protected void validateFunctionExpression(FunctionExpression expression) {
        super.validateFunctionExpression(expression);
        if (this.extension != EclipseLinkSemanticValidatorExtension.NULL_EXTENSION && expression.getIdentifier() == "COLUMN" && expression.hasExpression()) {
            String tableName;
            String entityName;
            JPQLQueryDeclaration declaration;
            String columnName = expression.getUnquotedFunctionName();
            String variableName = this.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
            if (ExpressionTools.stringIsNotEmpty(variableName) && ExpressionTools.stringIsNotEmpty(columnName) && (declaration = this.getDeclaration(variableName)).getType().isRange() && (entityName = this.literal(declaration.getBaseExpression(), LiteralType.ABSTRACT_SCHEMA_NAME)) != "" && ExpressionTools.stringIsNotEmpty(tableName = this.extension.getEntityTable(entityName)) && !this.extension.columnExists(tableName, expression.getUnquotedFunctionName())) {
                int startPosition = this.position(expression) + "COLUMN".length() + (expression.hasLeftParenthesis() ? 1 : 0);
                int endPosition = startPosition + expression.getFunctionName().length();
                this.addProblem((Expression)expression, startPosition, endPosition, "FUNCTION_EXPRESSION_UNKNOWN_COLUMN", columnName, tableName);
            }
        }
    }

    @Override
    protected void validateInExpression(InExpression expression) {
        super.validateInExpression(expression);
        Expression inItems = expression.getInItems();
        if (this.isSubquery(inItems)) {
            int nestedArraySize = this.nestedArraySize(expression.getExpression());
            int subquerySelectItemsSize = this.subquerySelectItemCount(inItems);
            if (nestedArraySize > -1 && subquerySelectItemsSize != nestedArraySize || nestedArraySize == -1 && subquerySelectItemsSize > 1) {
                this.addProblem(expression, "IN_EXPRESSION_INVALID_ITEM_COUNT");
            }
        }
    }

    @Override
    protected void validateRangeVariableDeclarationRootObject(RangeVariableDeclaration expression) {
        Expression rootObject = expression.getRootObject();
        CollectionValuedPathExpression pathExpression = this.getCollectionValuedPathExpression(rootObject);
        if (pathExpression != null) {
            String path = pathExpression.toActualText();
            if (this.helper.getType(path) == null) {
                pathExpression.accept(this);
            }
        } else {
            rootObject.accept(this);
        }
    }

    @Override
    protected AbstractSemanticValidator.PathType validPathExpressionTypeForCountFunction() {
        return AbstractSemanticValidator.PathType.ANY_FIELD_INCLUDING_COLLECTION;
    }

    @Override
    protected AbstractSemanticValidator.PathType validPathExpressionTypeForInExpression() {
        return AbstractSemanticValidator.PathType.ANY_FIELD_INCLUDING_COLLECTION;
    }

    @Override
    protected AbstractSemanticValidator.PathType validPathExpressionTypeForInItem() {
        return AbstractSemanticValidator.PathType.ANY_FIELD_INCLUDING_COLLECTION;
    }

    @Override
    protected Boolean validateThirdPartyStateFieldPathExpression(StateFieldPathExpression expression) {
        JPQLQueryDeclaration declaration;
        Boolean valid = null;
        String variableName = this.literal(expression.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
        if (variableName != "" && (declaration = this.getDeclaration(variableName)) != null) {
            if (declaration.getType() == JPQLQueryDeclaration.Type.SUBQUERY) {
                valid = Boolean.TRUE;
            } else {
                Expression baseExpression = declaration.getBaseExpression();
                if (baseExpression != null && this.isTableExpression(baseExpression)) {
                    if (this.extension == EclipseLinkSemanticValidatorExtension.NULL_EXTENSION) {
                        valid = Boolean.TRUE;
                    } else {
                        valid = Boolean.FALSE;
                        String tableName = this.literal(baseExpression, LiteralType.STRING_LITERAL);
                        if (tableName != "" && (tableName = ExpressionTools.unquote(tableName)) != null && this.extension.tableExists(tableName)) {
                            String columnName = expression.getPath(1);
                            if (!this.extension.columnExists(tableName, columnName)) {
                                this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_UNKNOWN_COLUMN", columnName, tableName);
                            } else {
                                valid = Boolean.TRUE;
                            }
                        }
                    }
                }
            }
        }
        return valid;
    }

    @Override
    protected AbstractSemanticValidator.PathType validPathExpressionTypeForStringExpression() {
        return AbstractSemanticValidator.PathType.ANY_FIELD_INCLUDING_COLLECTION;
    }

    @Override
    public void visit(AsOfClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(CastExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ConnectByClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(DatabaseType expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ExtractExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(HierarchicalQueryClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(OrderSiblingsByClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(RegexpExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(StartWithClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(TableExpression expression) {
        Expression tableNameExpression;
        String tableName;
        super.visit(expression);
        if (this.extension != EclipseLinkSemanticValidatorExtension.NULL_EXTENSION && (tableName = this.literal(tableNameExpression = expression.getExpression(), LiteralType.STRING_LITERAL)) != "" && (tableName = ExpressionTools.unquote(tableName)).length() > 0 && !this.extension.tableExists(tableName)) {
            this.addProblem(tableNameExpression, "TABLE_EXPRESSION_INVALID_TABLE_NAME");
        }
    }

    @Override
    public void visit(TableVariableDeclaration expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UnionClause expression) {
        super.visit(expression);
    }

    public static final class EclipseLinkOwningClauseVisitor
    extends AbstractValidator.OwningClauseVisitor {
        public UnionClause unionClause;

        @Override
        public void dispose() {
            super.dispose();
            this.unionClause = null;
        }

        public void visit(UnionClause expression) {
            this.unionClause = expression;
        }
    }

    protected static final class SubquerySelectItemCalculator
    extends AnonymousExpressionVisitor {
        public int count;

        protected SubquerySelectItemCalculator() {
        }

        @Override
        public void visit(BadExpression expression) {
            this.count = 0;
        }

        @Override
        public void visit(CollectionExpression expression) {
            this.count = expression.childrenSize();
        }

        @Override
        protected void visit(Expression expression) {
            this.count = 1;
        }

        @Override
        public void visit(NullExpression expression) {
            this.count = 0;
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            expression.getSelectClause().accept(this);
        }
    }

    protected static final class TableExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        protected Expression expression;
        protected boolean valid;

        protected TableExpressionVisitor() {
        }

        @Override
        public void visit(TableExpression expression) {
            this.valid = this.expression == expression;
        }
    }

    protected static final class TopLevelFirstDeclarationVisitor
    extends AbstractSemanticValidator.TopLevelFirstDeclarationVisitor {
        private final AbstractEclipseLinkSemanticValidator validator;

        private TopLevelFirstDeclarationVisitor(AbstractEclipseLinkSemanticValidator validator) {
            this.validator = validator;
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            EclipseLinkVersion version = EclipseLinkVersion.value(this.validator.getProviderVersion());
            this.valid = version.isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_4);
            if (this.valid) {
                Object type2 = this.validator.helper.getType(expression.toActualText());
                this.valid = this.validator.helper.isTypeResolvable(type2);
            }
        }
    }
}

