/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Host;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.logging.annotation.LogMessageInfo;

final class StandardEngineValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardEngineValve/1.0";
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="No Host matches server name {0}", level="WARNING")
    public static final String NO_HOST_MATCH = "AS-WEB-CORE-00197";

    StandardEngineValve() {
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        Host host = this.preInvoke(request, response);
        if (host == null) {
            return 2;
        }
        if (host.getPipeline().hasNonBasicValves() || host.hasCustomPipeline()) {
            host.getPipeline().invoke(request, response);
        } else {
            host.getPipeline().getBasic().invoke(request, response);
        }
        return 2;
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        Host host = this.preInvoke(request, response);
        if (host == null) {
            return;
        }
        if (host.getPipeline().hasNonBasicValves() || host.hasCustomPipeline()) {
            host.getPipeline().invoke(request, response);
        } else {
            host.getPipeline().getBasic().invoke(request, response);
        }
    }

    private Host preInvoke(Request request, Response response) throws IOException, ServletException {
        Host host = request.getHost();
        if (host == null) {
            ((HttpServletResponse)response.getResponse()).sendError(400);
            String msg = MessageFormat.format(rb.getString(NO_HOST_MATCH), request.getRequest().getServerName());
            response.setDetailMessage(msg);
            return null;
        }
        return host;
    }
}

