/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.eventbus;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import java.util.HashSet;

public class TopicListener
implements MessageListener {
    private String topicName;
    private String registrationID;
    private HashSet<MessageReceiver> receivers;

    public TopicListener(String topicName) {
        this.topicName = topicName;
        this.receivers = new HashSet(2);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getRegistrationID() {
        return this.registrationID;
    }

    public void setRegistrationID(String registrationID) {
        this.registrationID = registrationID;
    }

    public void onMessage(Message msg) {
        for (MessageReceiver receiver : this.receivers) {
            receiver.receiveMessage((ClusterMessage)msg.getMessageObject());
        }
    }

    void addMessageReceiver(MessageReceiver mr) {
        this.receivers.add(mr);
    }

    int removeMessageReceiver(MessageReceiver mr) {
        this.receivers.remove(mr);
        return this.receivers.size();
    }
}

