/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.eventbus;

import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.nucleus.eventbus.TopicListener;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-event-bus")
@RunLevel(value=10)
public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;
    private HashMap<String, TopicListener> messageReceivers;

    @PostConstruct
    public void postConstruct() {
        if (this.hzCore.isEnabled()) {
            logger.info("Payara Clustered Event Bus Enabled");
        }
        this.messageReceivers = new HashMap(2);
    }

    public boolean publish(String topic, ClusterMessage message) {
        boolean result = false;
        if (this.hzCore.isEnabled()) {
            this.hzCore.getInstance().getTopic(topic).publish(message);
            result = true;
        }
        return result;
    }

    public boolean addMessageReceiver(String topic, MessageReceiver mr) {
        boolean result = false;
        if (this.hzCore.isEnabled()) {
            TopicListener tl = this.messageReceivers.get(topic);
            if (tl == null) {
                TopicListener newTL = new TopicListener(topic);
                String regId = this.hzCore.getInstance().getTopic(topic).addMessageListener(newTL);
                this.messageReceivers.put(topic, newTL);
                tl = newTL;
                tl.setRegistrationID(regId);
            }
            tl.addMessageReceiver(mr);
            result = true;
        }
        return result;
    }

    public void removeMessageReceiver(String topic, MessageReceiver mr) {
        int remaining;
        TopicListener tl = this.messageReceivers.get(topic);
        if (tl != null && (remaining = tl.removeMessageReceiver(mr)) == 0) {
            this.messageReceivers.remove(topic);
            if (this.hzCore.isEnabled()) {
                this.hzCore.getInstance().getTopic(topic).removeMessageListener(tl.getRegistrationID());
            }
        }
    }
}

