/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionAdminBean;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.transaction.jts.ResourceRecoveryManagerImpl;
import com.sun.enterprise.transaction.jts.recovery.GMSCallBack;
import com.sun.enterprise.transaction.jts.recovery.OracleXAResource;
import com.sun.enterprise.transaction.jts.recovery.SybaseXAResource;
import com.sun.enterprise.transaction.spi.JavaEETransactionManagerDelegate;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DefaultTransactionService;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEETransactionManagerJTSDelegate
implements JavaEETransactionManagerDelegate,
PostConstruct {
    @Inject
    private ServiceLocator serviceLocator;
    private JavaEETransactionManager javaEETM;
    private ThreadLocal<TransactionManager> tmLocal = new ThreadLocal();
    private Hashtable globalTransactions;
    private Hashtable<String, XAResourceWrapper> xaresourcewrappers = new Hashtable();
    private Logger _logger;
    private static StringManager sm = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private boolean lao = true;
    private static final ReadWriteLock lock = new ReadWriteLock();
    private static JavaEETransactionManagerJTSDelegate instance = null;
    private volatile TransactionManager transactionManagerImpl = null;
    private TransactionService txnService = null;

    public JavaEETransactionManagerJTSDelegate() {
        this.globalTransactions = new Hashtable();
    }

    @Override
    public void postConstruct() {
        if (this.javaEETM != null) {
            this.javaEETM.setDelegate(this);
        }
        this._logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, "javax.enterprise.resource.jta");
        this.initTransactionProperties();
        JavaEETransactionManagerJTSDelegate.setInstance(this);
    }

    @Override
    public boolean useLAO() {
        return this.lao;
    }

    @Override
    public void setUseLAO(boolean b) {
        this.lao = b;
    }

    @Override
    public void commitDistributedTransaction() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: commit");
        }
        this.validateTransactionManager();
        TransactionManager tm = this.tmLocal.get();
        Transaction obj = tm.getTransaction();
        JavaEETransactionManagerSimplified javaEETMS = (JavaEETransactionManagerSimplified)this.javaEETM;
        boolean success = false;
        if (javaEETMS.isInvocationStackEmpty()) {
            try {
                tm.commit();
                success = true;
            }
            catch (HeuristicMixedException e) {
                success = true;
                throw e;
            }
            finally {
                javaEETMS.monitorTxCompleted(obj, success);
            }
        }
        try {
            javaEETMS.setTransactionCompeting(true);
            tm.commit();
            success = true;
        }
        catch (HeuristicMixedException e) {
            success = true;
            throw e;
        }
        finally {
            javaEETMS.monitorTxCompleted(obj, success);
            javaEETMS.setTransactionCompeting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackDistributedTransaction() throws IllegalStateException, SecurityException, SystemException {
        block8: {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "TM: rollback");
            }
            this.validateTransactionManager();
            TransactionManager tm = this.tmLocal.get();
            Transaction obj = tm.getTransaction();
            JavaEETransactionManagerSimplified javaEETMS = (JavaEETransactionManagerSimplified)this.javaEETM;
            try {
                if (javaEETMS.isInvocationStackEmpty()) {
                    tm.rollback();
                    break block8;
                }
                try {
                    javaEETMS.setTransactionCompeting(true);
                    tm.rollback();
                }
                finally {
                    javaEETMS.setTransactionCompeting(false);
                }
            }
            finally {
                javaEETMS.monitorTxCompleted(obj, false);
            }
        }
    }

    @Override
    public int getStatus() throws SystemException {
        JavaEETransaction tx = this.javaEETM.getCurrentTransaction();
        int status = 6;
        TransactionManager tm = this.tmLocal.get();
        if (tx != null) {
            status = tx.getStatus();
        } else if (tm != null) {
            status = tm.getStatus();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: status: " + JavaEETransactionManagerSimplified.getStatusAsString(status));
        }
        return status;
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        JavaEETransaction tx = this.javaEETM.getCurrentTransaction();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: getTransaction: tx=" + tx + ", tm=" + this.tmLocal.get());
        }
        if (tx != null) {
            return tx;
        }
        TransactionInternal jtsTx = null;
        TransactionManager tm = this.tmLocal.get();
        if (tm != null) {
            jtsTx = (TransactionInternal)tm.getTransaction();
        }
        if (jtsTx == null) {
            return null;
        }
        tx = (JavaEETransaction)this.globalTransactions.get(jtsTx);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: getTransaction: tx=" + tx + ", jtsTx=" + jtsTx);
        }
        if (tx == null) {
            tx = ((JavaEETransactionManagerSimplified)this.javaEETM).createImportedTransaction(jtsTx);
            this.globalTransactions.put(jtsTx, tx);
        }
        this.javaEETM.setCurrentTransaction(tx);
        return tx;
    }

    @Override
    public JavaEETransaction getJavaEETransaction(Transaction t) {
        if (t instanceof JavaEETransaction) {
            return (JavaEETransaction)t;
        }
        return (JavaEETransaction)this.globalTransactions.get(t);
    }

    @Override
    public boolean enlistDistributedNonXAResource(Transaction tx, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        if (this.useLAO()) {
            if (((JavaEETransactionManagerSimplified)this.javaEETM).resourceEnlistable(h)) {
                XAResource res = h.getXAResource();
                boolean result = tx.enlistResource(res);
                if (!h.isEnlisted()) {
                    h.enlistedInTransaction(tx);
                }
                return result;
            }
            return true;
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
    }

    @Override
    public boolean enlistLAOResource(Transaction tran, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        if (tran instanceof JavaEETransaction) {
            JavaEETransaction tx = (JavaEETransaction)tran;
            ((JavaEETransactionManagerSimplified)this.javaEETM).startJTSTx(tx);
            if (this.useLAO() && h != null && tx.getLAOResource() == null) {
                tx.setLAOResource(h);
                if (h.isTransactional()) {
                    XAResource res = h.getXAResource();
                    return tran.enlistResource(res);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setRollbackOnlyDistributedTransaction() throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: setRollbackOnly");
        }
        this.validateTransactionManager();
        this.tmLocal.get().setRollbackOnly();
    }

    @Override
    public Transaction suspend(JavaEETransaction tx) throws SystemException {
        if (tx != null) {
            if (!tx.isLocalTx()) {
                this.suspendXA();
            }
            this.javaEETM.setCurrentTransaction(null);
            return tx;
        }
        if (this.tmLocal.get() != null) {
            return this.suspendXA();
        }
        return null;
    }

    @Override
    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: resume");
        }
        if (this.transactionManagerImpl != null) {
            this.setTransactionManager();
            this.tmLocal.get().resume(tx);
        }
    }

    @Override
    public void removeTransaction(Transaction tx) {
        this.globalTransactions.remove(tx);
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public void setTransactionManager(JavaEETransactionManager tm) {
        this.javaEETM = tm;
        this._logger = ((JavaEETransactionManagerSimplified)this.javaEETM).getLogger();
    }

    @Override
    public TransactionInternal startJTSTx(JavaEETransaction tran, boolean isAssociatedTimeout) throws RollbackException, IllegalStateException, SystemException {
        this.setTransactionManager();
        JavaEETransactionImpl tx = (JavaEETransactionImpl)tran;
        try {
            if (isAssociatedTimeout) {
                int timeout = tx.cancelTimerTask();
                int newtimeout = (int)((System.currentTimeMillis() - tx.getStartTime()) / 1000L);
                newtimeout = timeout - newtimeout;
                this.beginJTS(newtimeout);
            } else {
                this.beginJTS(((JavaEETransactionManagerSimplified)this.javaEETM).getEffectiveTimeout());
            }
        }
        catch (NotSupportedException ex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.lazy_transaction_notstarted"), ex);
        }
        TransactionInternal jtsTx = (TransactionInternal)this.tmLocal.get().getTransaction();
        this.globalTransactions.put(jtsTx, tx);
        return jtsTx;
    }

    @Override
    public void initRecovery(boolean force) {
        TransactionServiceProperties.initRecovery(force);
    }

    @Override
    public void recover(XAResource[] resourceList) {
        this.setTransactionManager();
        TransactionManagerImpl.recover(Collections.enumeration(Arrays.asList(resourceList)));
    }

    @Override
    public void release(Xid xid) throws WorkException {
        this.setTransactionManager();
        TransactionManagerImpl.release(xid);
    }

    @Override
    public void recreate(Xid xid, long timeout) throws WorkException {
        this.setTransactionManager();
        TransactionManagerImpl.recreate(xid, timeout);
    }

    @Override
    public XATerminator getXATerminator() {
        this.setTransactionManager();
        return TransactionManagerImpl.getXATerminator();
    }

    private Transaction suspendXA() throws SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: suspend");
        }
        this.validateTransactionManager();
        return this.tmLocal.get().suspend();
    }

    private void validateTransactionManager() throws IllegalStateException {
        if (this.tmLocal.get() == null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
        }
    }

    private void setTransactionManager() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: setTransactionManager: tm=" + this.tmLocal.get());
        }
        if (this.transactionManagerImpl == null) {
            this.transactionManagerImpl = TransactionManagerImpl.getTransactionManagerImpl();
        }
        if (this.tmLocal.get() == null) {
            this.tmLocal.set(this.transactionManagerImpl);
        }
    }

    @Override
    public XAResourceWrapper getXAResourceWrapper(String clName) {
        XAResourceWrapper rc = this.xaresourcewrappers.get(clName);
        if (rc != null) {
            return rc.getInstance();
        }
        return null;
    }

    @Override
    public void handlePropertyUpdate(String name, Object value) {
        if (name.equals("keypoint-interval")) {
            Configuration.setKeypointTrigger(Integer.parseInt((String)value, 10));
        } else if (name.equals("retry-timeout-in-seconds")) {
            Configuration.setCommitRetryVar((String)value);
        }
    }

    @Override
    public boolean recoverIncompleteTx(boolean delegated, String logPath, XAResource[] xaresArray) throws Exception {
        boolean result = false;
        if (!delegated) {
            RecoveryManager.recoverIncompleteTx(xaresArray);
            result = true;
        } else {
            result = DelegatedRecoveryManager.delegated_recover(logPath, xaresArray);
        }
        return result;
    }

    public void beginJTS(int timeout) throws NotSupportedException, SystemException {
        TransactionManagerImpl tm = (TransactionManagerImpl)this.tmLocal.get();
        tm.begin(timeout);
        ((JavaEETransactionManagerSimplified)this.javaEETM).monitorTxBegin(tm.getTransaction());
    }

    @Override
    public boolean supportsXAResource() {
        return true;
    }

    public void initTransactionProperties() {
        if (this.serviceLocator != null) {
            this.txnService = this.serviceLocator.getService(TransactionService.class, "default-instance-name", new Annotation[0]);
            if (this.txnService != null) {
                String value = this.txnService.getPropertyValue("use-last-agent-optimization");
                if (value != null && "false".equals(value)) {
                    this.setUseLAO(false);
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.FINE, "TM: LAO is disabled");
                    }
                }
                if ((value = this.txnService.getPropertyValue("oracle-xa-recovery-workaround")) == null || "true".equals(value)) {
                    this.xaresourcewrappers.put("oracle.jdbc.xa.client.OracleXADataSource", new OracleXAResource());
                }
                if (Boolean.parseBoolean(this.txnService.getPropertyValue("sybase-xa-recovery-workaround"))) {
                    this.xaresourcewrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", new SybaseXAResource());
                }
                if (Boolean.parseBoolean(this.txnService.getAutomaticRecovery())) {
                    Properties props = TransactionServiceProperties.getJTSProperties(this.serviceLocator, false);
                    DefaultTransactionService.setServerName(props);
                    if (Boolean.parseBoolean(this.txnService.getPropertyValue("delegated-recovery"))) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.log(Level.FINE, "TM: Registering for GMS notification callback");
                        }
                        int waitTime = 60;
                        value = this.txnService.getPropertyValue("wait-time-before-recovery-insec");
                        if (value != null) {
                            try {
                                waitTime = Integer.parseInt(value);
                            }
                            catch (Exception e) {
                                this._logger.log(Level.WARNING, "error_wait_time_before_recovery", e);
                            }
                        }
                        new GMSCallBack(waitTime, this.serviceLocator);
                    }
                }
            }
        }
    }

    @Override
    public boolean isNullTransaction() {
        try {
            return InterceptorImpl.isTxCtxtNull();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public TransactionAdminBean getTransactionAdminBean(Transaction t) throws SystemException {
        TransactionAdminBean tBean = null;
        if (t instanceof TransactionImpl) {
            String id = ((TransactionImpl)t).getTransactionId();
            long startTime = ((TransactionImpl)t).getStartTime();
            long elapsedTime = System.currentTimeMillis() - startTime;
            String status = JavaEETransactionManagerSimplified.getStatusAsString(t.getStatus());
            JavaEETransactionImpl tran = (JavaEETransactionImpl)this.globalTransactions.get(t);
            if (tran != null) {
                tBean = ((JavaEETransactionManagerSimplified)this.javaEETM).getTransactionAdminBean(tran);
                tBean.setIdentifier(t);
                tBean.setId(id);
                tBean.setStatus(status);
                tBean.setElapsedTime(elapsedTime);
                if (tBean.getComponentName() == null) {
                    tBean.setComponentName("unknown");
                }
            } else {
                tBean = new TransactionAdminBean(t, id, status, elapsedTime, "unknown", null);
            }
        } else {
            tBean = ((JavaEETransactionManagerSimplified)this.javaEETM).getTransactionAdminBean(t);
        }
        return tBean;
    }

    @Override
    public String getTxLogLocation() {
        if (Configuration.getServerName() == null) {
            Properties props = TransactionServiceProperties.getJTSProperties(this.serviceLocator, false);
            DefaultTransactionService.setServerName(props);
        }
        return Configuration.getDirectory("com.sun.jts.logDirectory", "jts", new int[1]);
    }

    @Override
    public void registerRecoveryResourceHandler(XAResource xaResource) {
        ResourceRecoveryManagerImpl.registerRecoveryResourceHandler(xaResource);
    }

    @Override
    public Lock getReadLock() {
        return lock;
    }

    @Override
    public void acquireWriteLock() {
        if (AdminUtil.isFrozenAll()) {
            return;
        }
        AdminUtil.freezeAll();
        JavaEETransactionManagerJTSDelegate.lock.acquireWriteLock();
    }

    @Override
    public void releaseWriteLock() {
        if (AdminUtil.isFrozenAll()) {
            AdminUtil.unfreezeAll();
        }
        JavaEETransactionManagerJTSDelegate.lock.releaseWriteLock();
    }

    @Override
    public boolean isWriteLocked() {
        return AdminUtil.isFrozenAll();
    }

    public static JavaEETransactionManagerJTSDelegate getInstance() {
        return instance;
    }

    private static void setInstance(JavaEETransactionManagerJTSDelegate new_instance) {
        if (instance == null) {
            instance = new_instance;
        }
    }

    public void initXA() {
        this.setTransactionManager();
    }

    private static class ReadWriteLock
    implements Lock {
        private static final RWLock freezeLock = new RWLock();

        private ReadWriteLock() {
        }

        @Override
        public void lock() {
            freezeLock.acquireReadLock();
        }

        @Override
        public void unlock() {
            freezeLock.releaseReadLock();
        }

        private void acquireWriteLock() {
            freezeLock.acquireWriteLock();
        }

        private void releaseWriteLock() {
            freezeLock.releaseWriteLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

