/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.factory;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.factory.Factory;
import org.glassfish.apf.impl.AnnotationProcessorImpl;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SJSASFactory
extends Factory {
    @Inject
    private ServiceLocator locator;
    private Set<String> annotationClassNames = new HashSet<String>();
    private AnnotationProcessorImpl systemProcessor = null;

    public AnnotationProcessor getAnnotationProcessor() {
        AnnotationProcessorImpl processor = Factory.getDefaultAnnotationProcessor();
        processor.setDelegate(this.systemProcessor);
        return processor;
    }

    public Set<String> getAnnotations() {
        return (HashSet)((HashSet)this.annotationClassNames).clone();
    }

    private static String getAnnotationHandlerForStringValue(ActiveDescriptor<AnnotationHandler> onMe) {
        Map<String, List<String>> metadata = onMe.getMetadata();
        List<String> answers = metadata.get("AnnotationHandlerFor");
        if (answers == null || answers.isEmpty()) {
            return null;
        }
        return answers.get(0);
    }

    @PostConstruct
    private void postConstruct() {
        if (this.systemProcessor != null) {
            return;
        }
        this.systemProcessor = new AnnotationProcessorImpl();
        for (ActiveDescriptor<AnnotationHandler> activeDescriptor : this.locator.getDescriptors(BuilderHelper.createContractFilter(AnnotationHandler.class.getName()))) {
            ActiveDescriptor<AnnotationHandler> descriptor = activeDescriptor;
            String annotationTypeName = SJSASFactory.getAnnotationHandlerForStringValue(descriptor);
            if (annotationTypeName == null) continue;
            this.systemProcessor.pushAnnotationHandler(annotationTypeName, new LazyAnnotationHandler(descriptor));
            this.annotationClassNames.add("L" + annotationTypeName.replace('.', '/') + ";");
        }
    }

    private class LazyAnnotationHandler
    implements AnnotationHandler {
        private final ActiveDescriptor<AnnotationHandler> descriptor;
        private AnnotationHandler handler;

        private LazyAnnotationHandler(ActiveDescriptor<AnnotationHandler> descriptor) {
            this.descriptor = descriptor;
        }

        private AnnotationHandler getHandler() {
            if (this.handler != null) {
                return this.handler;
            }
            this.handler = SJSASFactory.this.locator.getServiceHandle(this.descriptor).getService();
            return this.handler;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return this.getHandler().getAnnotationType();
        }

        @Override
        public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
            return this.getHandler().processAnnotation(element);
        }

        @Override
        public Class<? extends Annotation>[] getTypeDependencies() {
            return this.getHandler().getTypeDependencies();
        }
    }
}

