/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionDefinitionUtils {
    private static final Logger _logger = LogDomains.getLogger(ConnectionDefinitionUtils.class, "javax.enterprise.resource.resourceadapter");
    private static final Locale locale = Locale.getDefault();

    public static Set getConnectionDefinitionProperties(String connectionDefinitionClassName) {
        TreeMap<String, String> propertySet = new TreeMap<String, String>();
        try {
            Method[] methods = ConnectorRuntime.getRuntime().getConnectorClassLoader().loadClass(connectionDefinitionClassName).getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!ConnectionDefinitionUtils.isValidSetterMethod(methods[i])) continue;
                String name = methods[i].getName();
                String propertyName = name.substring(name.indexOf("set") + "set".length(), name.length());
                propertySet.put(propertyName, propertyName);
            }
        }
        catch (SecurityException e) {
            ConnectionDefinitionUtils.handleException(e, connectionDefinitionClassName);
        }
        catch (ClassNotFoundException e) {
            ConnectionDefinitionUtils.handleException(e, connectionDefinitionClassName);
        }
        ConnectionDefinitionUtils.ignoreOracle10gProperties(connectionDefinitionClassName, propertySet);
        return propertySet.keySet();
    }

    private static void ignoreOracle10gProperties(String className, Map map) {
        HashSet<String> oracleClasses = new HashSet<String>();
        oracleClasses.add("oracle.jdbc.pool.oracledatasource");
        oracleClasses.add("oracle.jdbc.pool.oracleconnectionpooldatasource");
        oracleClasses.add("oracle.jdbc.xa.client.oraclexadatasource");
        oracleClasses.add("oracle.jdbc.xa.oraclexadataSource");
        if (oracleClasses.contains(className.toLowerCase(locale))) {
            boolean property1Removed = ConnectionDefinitionUtils.removePropertyFromMap("connectionCachingEnabled", map);
            boolean property2Removed = ConnectionDefinitionUtils.removePropertyFromMap("fastConnectionFailoverEnabled", map);
            if ((property1Removed || property2Removed) && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Removing properties 'connectionCachingEnabled', 'fastConnectionFailoverEnabled' from Datasource : " + className);
            }
        }
    }

    private static boolean removePropertyFromMap(String property, Map map) {
        boolean entryRemoved = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!property.equalsIgnoreCase(key)) continue;
            iterator.remove();
            entryRemoved = true;
        }
        return entryRemoved;
    }

    private static boolean isValidSetterMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && ConnectionDefinitionUtils.isValidArgumentType(method);
    }

    private static boolean isValidArgumentType(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        boolean isValid = true;
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> param = parameters[i];
            if (param.isPrimitive() || param.equals(String.class)) continue;
            return false;
        }
        return isValid;
    }

    public static Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName, String resType) {
        TreeMap<String, Object> hm = new TreeMap<String, Object>();
        if (connectionDefinitionClassName == null || "".equals(connectionDefinitionClassName)) {
            if (resType != null && resType.equals("java.sql.Driver")) {
                ConnectionDefinitionUtils.addDefaultJDBCDriverProperties(hm);
            } else {
                ConnectionDefinitionUtils.addDefaultJDBCProperties(hm);
            }
            return hm;
        }
        Set s = ConnectionDefinitionUtils.getConnectionDefinitionProperties(connectionDefinitionClassName);
        try {
            Class<?> connectionDefinitionClass = ConnectorRuntime.getRuntime().getConnectorClassLoader().loadClass(connectionDefinitionClassName);
            Object obj = connectionDefinitionClass.newInstance();
            for (String property : s) {
                Object defaultVal = null;
                try {
                    Method m = connectionDefinitionClass.getMethod("get" + property, new Class[0]);
                    defaultVal = m.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                hm.put(property, defaultVal);
            }
            if (resType != null && resType.equals("java.sql.Driver")) {
                ConnectionDefinitionUtils.addDefaultJDBCDriverProperties(hm);
            }
        }
        catch (ClassNotFoundException e) {
            ConnectionDefinitionUtils.handleException(e, connectionDefinitionClassName);
            if (resType != null && resType.equals("java.sql.Driver")) {
                ConnectionDefinitionUtils.addDefaultJDBCDriverProperties(hm);
            } else {
                ConnectionDefinitionUtils.addDefaultJDBCProperties(hm);
            }
        }
        catch (InstantiationException e) {
            ConnectionDefinitionUtils.handleException(e, connectionDefinitionClassName);
        }
        catch (IllegalAccessException e) {
            ConnectionDefinitionUtils.handleException(e, connectionDefinitionClassName);
        }
        catch (SecurityException e) {
            ConnectionDefinitionUtils.handleException(e, connectionDefinitionClassName);
        }
        return hm;
    }

    private static void addDefaultJDBCProperties(Map map) {
        String[] defaultProperties = new String[]{"databaseName", "serverName", "portNumber", "networkProtocol", "user", "password", "roleName", "datasourceName"};
        for (int i = 0; i < defaultProperties.length; ++i) {
            map.put(defaultProperties[i], null);
        }
    }

    private static void addDefaultJDBCDriverProperties(Map map) {
        String[] defaultProperties = new String[]{"URL", "user", "password"};
        for (int i = 0; i < defaultProperties.length; ++i) {
            if (ConnectionDefinitionUtils.containsProperty(defaultProperties[i], map)) continue;
            map.put(defaultProperties[i], null);
        }
    }

    private static boolean containsProperty(String prop, Map map) {
        boolean propFound = false;
        Set keys = map.keySet();
        for (String key : keys) {
            if (!prop.equalsIgnoreCase(key)) continue;
            propFound = true;
            break;
        }
        return propFound;
    }

    private static void handleException(Exception ex, String className) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Exception while trying to find properties of class [ " + className + " ]", ex);
        }
        Object[] param = new Object[]{className, ex.getMessage()};
        _logger.log(Level.SEVERE, "error.finding.properties", param);
    }

    public static void main(String[] args) {
        Map<String, Object> m = ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults("sun.jdbc.odbc.ee.DataSource", "javax.sql.DataSource");
        Set<Map.Entry<String, Object>> elements = m.entrySet();
        for (Map.Entry<String, Object> element : elements) {
            System.out.println(element.getKey() + " : " + element.getValue());
        }
    }
}

