/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.remote.ServerRemoteAdminCommand;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.net.ConnectException;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.ServiceLocator;

public class InstanceCommandExecutor
extends ServerRemoteAdminCommand
implements Runnable,
InstanceCommand {
    private Server server;
    private ParameterMap params;
    private ActionReport aReport;
    private String commandName;
    private FailurePolicy offlinePolicy;
    private FailurePolicy failPolicy;
    private InstanceCommandResult result;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(InstanceCommandExecutor.class);

    public InstanceCommandExecutor(ServiceLocator habitat, String name, FailurePolicy fail, FailurePolicy offline, Server server, String host, int port, Logger logger2, ParameterMap p, ActionReport r, InstanceCommandResult res) throws CommandException {
        super(habitat, name, host, port, false, "admin", "", logger2);
        this.server = server;
        this.params = p;
        this.aReport = r;
        this.commandName = name;
        this.offlinePolicy = offline;
        this.failPolicy = fail;
        this.result = res;
    }

    @Override
    public String getCommandOutput() {
        return this.output;
    }

    public Server getServer() {
        return this.server;
    }

    public ActionReport getReport() {
        return this.aReport;
    }

    @Override
    public void run() {
        try {
            this.executeCommand(this.params);
            this.aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            if (StringUtils.ok(this.getCommandOutput())) {
                this.aReport.setMessage(strings.getLocalString("ice.successmessage", "{0}:\n{1}\n", this.getServer().getName(), this.getCommandOutput()));
            }
            Map<String, String> attributes = this.getAttributes();
            for (Map.Entry<String, String> ae : attributes.entrySet()) {
                String key = ae.getKey();
                if (key.endsWith("_value")) continue;
                if (!key.endsWith("_name")) {
                    if (ae.getValue() == null) continue;
                    this.aReport.getTopMessagePart().addProperty(key, ae.getValue());
                    continue;
                }
                String keyWithoutSuffix = key.substring(0, key.lastIndexOf("_name"));
                this.aReport.getTopMessagePart().addProperty(keyWithoutSuffix, attributes.get(keyWithoutSuffix + "_value"));
            }
        }
        catch (CommandException cmdEx) {
            ActionReport.ExitCode finalResult;
            if (cmdEx.getCause() instanceof ConnectException) {
                finalResult = FailurePolicy.applyFailurePolicy(this.offlinePolicy, ActionReport.ExitCode.FAILURE);
                if (!finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.warnoffline", "WARNING: Instance {0} seems to be offline; command {1} was not replicated to that instance", this.getServer().getName(), this.commandName));
                } else {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.failoffline", "FAILURE: Instance {0} seems to be offline; command {1} was not replicated to that instance", this.getServer().getName(), this.commandName));
                }
            } else {
                finalResult = FailurePolicy.applyFailurePolicy(this.failPolicy, ActionReport.ExitCode.FAILURE);
                if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.commandFailed", "FAILURE: Command {0} failed on server instance {1}: {2}", this.commandName, this.getServer().getName(), cmdEx.getMessage()));
                } else {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.commandWarning", "WARNING: Command {0} did not complete successfully on server instance {1}: {2}", this.commandName, this.getServer().getName(), cmdEx.getMessage()));
                }
            }
            this.aReport.setActionExitCode(finalResult);
        }
        this.result.setInstanceCommand(this);
    }
}

