/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SubstitutableTokens {
    public static final String CONFIG_MODEL_NAME_TOKEN_NAME = "CONFIG_MODEL_NAME";
    public static final String CONFIG_MODEL_NAME_TOKEN_VALUE = "server-config";
    public static final String HOST_NAME_TOKEN_NAME = "HOST_NAME";
    public static final String DOMAIN_NAME_TOKEN_NAME = "DOMAIN_NAME";
    public static final String HTTP_PORT_TOKEN_NAME = "HTTP_PORT";
    public static final String ORB_LISTENER_PORT_TOKEN_NAME = "ORB_LISTENER_PORT";
    public static final String JMS_PROVIDER_PORT_TOKEN_NAME = "JMS_PROVIDER_PORT";
    public static final String SERVER_ID_TOKEN_NAME = "SERVER_ID";
    public static final String ADMIN_PORT_TOKEN_NAME = "ADMIN_PORT";
    public static final String HTTP_SSL_PORT_TOKEN_NAME = "HTTP_SSL_PORT";
    public static final String ORB_SSL_PORT_TOKEN_NAME = "ORB_SSL_PORT";
    public static final String ORB_MUTUALAUTH_PORT_TOKEN_NAME = "ORB_MUTUALAUTH_PORT";
    public static final String OSGI_SHELL_TELNET_PORT_TOKEN_NAME = "OSGI_SHELL_TELNET_PORT";
    public static final String JAVA_DEBUGGER_PORT_TOKEN_NAME = "JAVA_DEBUGGER_PORT";
    public static final String ADMIN_CERT_DN_TOKEN_NAME = "ADMIN_CERT_DN";
    public static final String INSTANCE_CERT_DN_TOKEN_NAME = "INSTANCE_CERT_DN";
    public static final String SECURE_ADMIN_IDENTIFIER_TOKEN_NAME = "SECURE_ADMIN_IDENTIFIER";
    public static final String JMX_SYSTEM_CONNECTOR_PORT_TOKEN_NAME = "JMX_SYSTEM_CONNECTOR_PORT";
    public static final String VERSION_TOKEN_NAME = "VERSION";
    public static final String INSTALL_ROOT_TOKEN_NAME = "INSTALL_ROOT";
    public static final String SERVER_ROOT = "SERVER_ROOT";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String ORB_LISTENER1_PORT = "ORB_LISTENER1_PORT";
    private static final String DOMAIN_DIR = "DOMAIN_DIR";

    public static Map<String, String> getSubstitutableTokens(DomainConfig domainConfig) {
        HashMap<String, String> substitutableTokens = new HashMap<String, String>();
        Properties domainProperties = domainConfig.getDomainProperties();
        String instanceName = (String)domainConfig.get("server.id");
        if (instanceName == null || instanceName.equals("")) {
            instanceName = "server";
        }
        substitutableTokens.put(SERVER_ID_TOKEN_NAME, instanceName);
        substitutableTokens.put(DOMAIN_NAME_TOKEN_NAME, domainConfig.getRepositoryName());
        substitutableTokens.put(CONFIG_MODEL_NAME_TOKEN_NAME, CONFIG_MODEL_NAME_TOKEN_VALUE);
        substitutableTokens.put(HOST_NAME_TOKEN_NAME, (String)domainConfig.get("domain.hostName"));
        substitutableTokens.put(ADMIN_PORT_TOKEN_NAME, domainConfig.get("domain.adminPort").toString());
        substitutableTokens.put(HTTP_PORT_TOKEN_NAME, domainConfig.get("domain.instancePort").toString());
        substitutableTokens.put(ORB_LISTENER_PORT_TOKEN_NAME, domainConfig.get("orb.listener.port").toString());
        substitutableTokens.put(JMS_PROVIDER_PORT_TOKEN_NAME, domainConfig.get("jms.port").toString());
        substitutableTokens.put(HTTP_SSL_PORT_TOKEN_NAME, domainConfig.get("http.ssl.port").toString());
        substitutableTokens.put(ORB_SSL_PORT_TOKEN_NAME, domainConfig.get("orb.ssl.port").toString());
        substitutableTokens.put(ORB_MUTUALAUTH_PORT_TOKEN_NAME, domainConfig.get("orb.mutualauth.port").toString());
        substitutableTokens.put(JMX_SYSTEM_CONNECTOR_PORT_TOKEN_NAME, domainConfig.get("domain.jmxPort").toString());
        substitutableTokens.put(OSGI_SHELL_TELNET_PORT_TOKEN_NAME, domainConfig.get("osgi.shell.telnet.port").toString());
        substitutableTokens.put(JAVA_DEBUGGER_PORT_TOKEN_NAME, domainConfig.get("java.debugger.port").toString());
        substitutableTokens.put(ADMIN_CERT_DN_TOKEN_NAME, (String)domainConfig.get("domain.admin.cert.dn"));
        substitutableTokens.put(INSTANCE_CERT_DN_TOKEN_NAME, (String)domainConfig.get("domain.instance.cert.dn"));
        substitutableTokens.put(SECURE_ADMIN_IDENTIFIER_TOKEN_NAME, (String)domainConfig.get("domain.indicator"));
        substitutableTokens.put(VERSION_TOKEN_NAME, Version.getFullVersion());
        substitutableTokens.put(INSTALL_ROOT_TOKEN_NAME, domainConfig.getInstallRoot());
        substitutableTokens.put(SERVER_ROOT, FileUtils.makeForwardSlashes(domainConfig.getInstallRoot()));
        substitutableTokens.put(SERVER_NAME, domainConfig.get("domain.hostName").toString());
        substitutableTokens.put(ORB_LISTENER1_PORT, domainConfig.get("orb.listener.port").toString());
        String domainLocation = new File(domainConfig.getRepositoryRoot(), domainConfig.getRepositoryName()).getAbsolutePath();
        substitutableTokens.put(DOMAIN_DIR, domainLocation);
        for (String pname : domainProperties.stringPropertyNames()) {
            if (substitutableTokens.containsKey(pname)) continue;
            substitutableTokens.put(pname, domainProperties.getProperty(pname));
        }
        return substitutableTokens;
    }
}

