/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.cli.DomainXmlVerifier;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Service(name="verify-domain-xml")
@PerLookup
public final class VerifyDomainXmlCommand
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(VerifyDomainXmlCommand.class);

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        File domainXMLFile = this.getDomainXml();
        logger.log(Level.FINER, "Domain XML file = {0}", domainXMLFile);
        try {
            URL domainURL;
            ArrayList<URL> urls = new ArrayList<URL>();
            File idir = new File(System.getProperty("com.sun.aas.installRoot"));
            File mdir = new File(idir, "modules");
            for (File f : mdir.listFiles()) {
                if (!f.toString().endsWith(".jar")) continue;
                urls.add(f.toURI().toURL());
            }
            final URL[] urlsA = urls.toArray(new URL[urls.size()]);
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new URLClassLoader(urlsA, Globals.class.getClassLoader());
                }
            });
            StaticModulesRegistry registry = new StaticModulesRegistry(cl);
            ServiceLocator serviceLocator = registry.createServiceLocator("default");
            ConfigParser parser = new ConfigParser(serviceLocator);
            DomDocument doc = parser.parse(domainURL = domainXMLFile.toURI().toURL());
            Dom domDomain = doc.getRoot();
            Domain domain = domDomain.createProxy(Domain.class);
            DomainXmlVerifier validator = new DomainXmlVerifier(domain);
            if (validator.invokeConfigValidator()) {
                return 1;
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        return 0;
    }
}

