/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.admin.monitor.callflow.CallFlowInfo;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.util.io.FileUtils;
import java.lang.reflect.Method;
import java.security.Principal;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

final class CallFlowInfoImpl
implements CallFlowInfo {
    private final BaseContainer container;
    private final EjbDescriptor ejbDescriptor;
    private final String appName;
    private final String modName;
    private final String ejbName;
    private final ComponentType componentType;

    CallFlowInfoImpl(BaseContainer container, EjbDescriptor descriptor, ComponentType compType) {
        this.container = container;
        this.ejbDescriptor = descriptor;
        this.appName = this.ejbDescriptor.getApplication().isVirtual() ? null : this.ejbDescriptor.getApplication().getRegistrationName();
        String archiveuri = this.ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
        this.modName = FileUtils.makeFriendlyFilename(archiveuri);
        this.ejbName = this.ejbDescriptor.getName();
        this.componentType = compType;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public String getModuleName() {
        return this.modName;
    }

    @Override
    public String getComponentName() {
        return this.ejbName;
    }

    @Override
    public ComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    public Method getMethod() {
        EjbInvocation inv = (EjbInvocation)EjbContainerUtilImpl.getInstance().getCurrentInvocation();
        return inv.method;
    }

    @Override
    public String getTransactionId() {
        JavaEETransaction tx = null;
        try {
            tx = (JavaEETransaction)EjbContainerUtilImpl.getInstance().getTransactionManager().getTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tx == null ? null : "" + tx;
    }

    @Override
    public String getCallerPrincipal() {
        Principal principal = this.container.getSecurityManager().getCallerPrincipal();
        return principal != null ? principal.getName() : null;
    }

    @Override
    public Throwable getException() {
        return ((EjbInvocation)EjbContainerUtilImpl.getInstance().getCurrentInvocation()).exception;
    }
}

