/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageBuilder;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;

class SocketClientMessageReader
implements SocketReader {
    private final ClientMessageBuilder builder;
    private final TcpIpConnection connection;

    public SocketClientMessageReader(TcpIpConnection connection, SocketChannelWrapper socketChannel) throws IOException {
        this.connection = connection;
        this.readType(socketChannel);
        this.builder = new ClientMessageBuilder(new ClientSocketMessageHandler(connection));
    }

    @Override
    public void read(ByteBuffer inBuffer) throws Exception {
        this.builder.onData(inBuffer);
    }

    private void readType(SocketChannelWrapper socketChannel) throws IOException {
        ByteBuffer clientTypeBuffer = ByteBuffer.allocate(3);
        do {
            socketChannel.read(clientTypeBuffer);
        } while (clientTypeBuffer.hasRemaining());
        this.setConnectionType(clientTypeBuffer.array());
    }

    private void setConnectionType(byte[] typeBytes) {
        String type2 = StringUtil.bytesToString(typeBytes);
        if ("JVM".equals(type2)) {
            this.connection.setType(ConnectionType.JAVA_CLIENT);
        } else if ("CSP".equals(type2)) {
            this.connection.setType(ConnectionType.CSHARP_CLIENT);
        } else if ("CPP".equals(type2)) {
            this.connection.setType(ConnectionType.CPP_CLIENT);
        } else if ("PHY".equals(type2)) {
            this.connection.setType(ConnectionType.PYTHON_CLIENT);
        } else if ("RBY".equals(type2)) {
            this.connection.setType(ConnectionType.RUBY_CLIENT);
        } else {
            IOService ioService = this.connection.getConnectionManager().ioService;
            ioService.getLogger(this.getClass().getName()).info("Unknown client type: " + type2);
            this.connection.setType(ConnectionType.BINARY_CLIENT);
        }
    }

    private static class ClientSocketMessageHandler
    implements ClientMessageBuilder.MessageHandler {
        private final TcpIpConnection connection;
        private final IOService ioService;

        public ClientSocketMessageHandler(TcpIpConnection connection) {
            this.connection = connection;
            this.ioService = connection.getConnectionManager().getIOHandler();
        }

        @Override
        public void handleMessage(ClientMessage message) {
            this.ioService.handleClientMessage(message, this.connection);
        }
    }
}

