/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import java.security.Permission;
import java.util.Set;

public class CacheAddEntryListenerMessageTask
extends AbstractCallableMessageTask<CacheAddEntryListenerCodec.RequestParameters> {
    public CacheAddEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        CacheService service = (CacheService)this.getService("hz:impl:cacheService");
        CacheEventListener entryListener = new CacheEventListener(){

            @Override
            public void handleEvent(Object eventObject) {
                if (!endpoint.isAlive()) {
                    return;
                }
                if (eventObject instanceof CacheEventSet) {
                    CacheEventSet ces = (CacheEventSet)eventObject;
                    Data partitionKey = CacheAddEntryListenerMessageTask.this.getPartitionKey(eventObject);
                    ClientMessage clientMessage = CacheAddEntryListenerCodec.encodeCacheEvent(ces.getEventType().getType(), ces.getEvents(), ces.getCompletionId());
                    CacheAddEntryListenerMessageTask.this.sendClientMessage(partitionKey, clientMessage);
                }
            }
        };
        return service.registerListener(((CacheAddEntryListenerCodec.RequestParameters)this.parameters).name, entryListener);
    }

    private Data getPartitionKey(Object eventObject) {
        Data partitionKey = null;
        if (eventObject instanceof CacheEventSet) {
            Set<CacheEventData> events = ((CacheEventSet)eventObject).getEvents();
            if (events.size() > 1) {
                partitionKey = new DefaultData();
            } else if (events.size() == 1) {
                partitionKey = events.iterator().next().getDataKey();
            }
        } else if (eventObject instanceof CacheEventData) {
            partitionKey = ((CacheEventData)eventObject).getDataKey();
        }
        return partitionKey;
    }

    @Override
    protected CacheAddEntryListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheAddEntryListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheAddEntryListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheAddEntryListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

