/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.operations.ClientReAuthOperation;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.UuidUtil;
import java.security.Permission;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AuthenticationBaseMessageTask<P>
extends AbstractCallableMessageTask<P> {
    protected transient ClientPrincipal principal;
    protected transient Credentials credentials;

    public AuthenticationBaseMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientEndpointImpl getEndpoint() {
        if (this.connection.isAlive()) {
            return new ClientEndpointImpl(this.clientEngine, this.connection);
        }
        this.handleEndpointNotCreatedConnectionNotAlive();
        return null;
    }

    @Override
    protected boolean isAuthenticationMessage() {
        return true;
    }

    private void handleEndpointNotCreatedConnectionNotAlive() {
        this.logger.warning("Dropped: " + this.clientMessage + " -> endpoint not created for AuthenticationRequest, connection not alive");
    }

    @Override
    public Object call() {
        boolean authenticated = this.authenticate();
        if (authenticated) {
            return this.handleAuthenticated();
        }
        return this.handleUnauthenticated();
    }

    private boolean authenticate() {
        boolean authenticated;
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService("hz:core:clientEngine");
        Connection connection = this.endpoint.getConnection();
        ILogger logger2 = clientEngine.getLogger(this.getClass());
        if (this.credentials == null) {
            authenticated = false;
            logger2.severe("Could not retrieve Credentials object!");
        } else if (clientEngine.getSecurityContext() != null) {
            authenticated = this.authenticate(clientEngine.getSecurityContext());
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            authenticated = this.authenticate(usernamePasswordCredentials);
        } else {
            authenticated = false;
            logger2.severe("Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        }
        logger2.log(authenticated ? Level.INFO : Level.WARNING, "Received auth from " + connection + ", " + (authenticated ? "successfully authenticated" : "authentication failed"));
        return authenticated;
    }

    private boolean authenticate(SecurityContext securityContext) {
        Connection connection = this.endpoint.getConnection();
        this.credentials.setEndpoint(connection.getInetAddress().getHostAddress());
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.credentials);
            lc.login();
            this.endpoint.setLoginContext(lc);
            return true;
        }
        catch (LoginException e) {
            this.logger.warning(e);
            return false;
        }
    }

    private boolean authenticate(UsernamePasswordCredentials credentials) {
        GroupConfig groupConfig = this.nodeEngine.getConfig().getGroupConfig();
        String nodeGroupName = groupConfig.getName();
        String nodeGroupPassword = groupConfig.getPassword();
        boolean usernameMatch = nodeGroupName.equals(credentials.getUsername());
        boolean passwordMatch = nodeGroupPassword.equals(credentials.getPassword());
        return usernameMatch && passwordMatch;
    }

    private Object handleUnauthenticated() {
        throw new AuthenticationException("Invalid credentials!");
    }

    private Object handleAuthenticated() {
        boolean isNotMember;
        if (this.isOwnerConnection()) {
            String uuid = this.getUuid();
            String localMemberUUID = this.clientEngine.getLocalMember().getUuid();
            this.principal = new ClientPrincipal(uuid, localMemberUUID);
            this.reAuthLocal();
            Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
            for (MemberImpl member : members) {
                if (member.localMember()) continue;
                ClientReAuthOperation op = new ClientReAuthOperation(uuid);
                op.setCallerUuid(localMemberUUID);
                this.nodeEngine.getOperationService().send(op, member.getAddress());
            }
        }
        boolean bl = isNotMember = this.clientEngine.getClusterService().getMember(this.principal.getOwnerUuid()) == null;
        if (isNotMember) {
            throw new AuthenticationException("Invalid owner-uuid: " + this.principal.getOwnerUuid() + ", it's not member of this cluster!");
        }
        this.endpoint.authenticated(this.principal, this.credentials, this.isOwnerConnection());
        this.endpointManager.registerEndpoint(this.endpoint);
        this.clientEngine.bind(this.endpoint);
        Address thisAddress = this.clientEngine.getThisAddress();
        return this.encodeAuth(thisAddress, this.principal.getUuid(), this.principal.getOwnerUuid());
    }

    protected abstract ClientMessage encodeAuth(Address var1, String var2, String var3);

    protected abstract boolean isOwnerConnection();

    private String getUuid() {
        if (this.principal != null) {
            return this.principal.getUuid();
        }
        return UuidUtil.createClientUuid(this.endpoint.getConnection().getEndPoint());
    }

    private void reAuthLocal() {
        Set<ClientEndpoint> endpoints = this.endpointManager.getEndpoints(this.principal.getUuid());
        for (ClientEndpoint endpoint : endpoints) {
            endpoint.authenticated(this.principal);
        }
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

