/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.osgiadapter.AbstractOSGiModulesRegistryImpl;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.jvnet.hk2.osgiadapter.OSGiObrModuleImpl;
import org.jvnet.hk2.osgiadapter.ObrHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;

public class OSGiObrModulesRegistryImpl
extends AbstractOSGiModulesRegistryImpl
implements SynchronousBundleListener {
    private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private final ObrHandler obrHandler;

    OSGiObrModulesRegistryImpl(BundleContext bctx) {
        super(bctx);
        this.obrHandler = new ObrHandler(bctx);
    }

    public void addObr(URI obrUri) throws Exception {
        this.obrHandler.addRepository(obrUri);
    }

    @Override
    public void addRepository(Repository repository, int weight) {
        if (repository instanceof OSGiDirectoryBasedRepository) {
            try {
                this.obrHandler.addRepository(repository.getLocation());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        super.addRepository(repository, weight);
    }

    @Override
    public void addRepository(Repository repository) {
        this.addRepository(repository, 1);
    }

    @Override
    protected Module newModule(ModuleDefinition moduleDef) {
        Bundle alreadyDeployedBundle = this.getExistingBundle(moduleDef);
        return new OSGiObrModuleImpl(this, alreadyDeployedBundle, moduleDef);
    }

    @Override
    protected Module loadFromRepository(String name, String version) {
        Bundle bundle2 = this.getObrHandler().deploy(name, version);
        return bundle2 != null ? this.getModule(bundle2) : null;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                Module module = this.getModule(event.getBundle());
                if (!(module instanceof OSGiObrModuleImpl)) break;
                ((OSGiObrModuleImpl)OSGiObrModuleImpl.class.cast(module)).setBundle(event.getBundle());
                return;
            }
        }
    }

    @Override
    public void shutdown() {
        this.getObrHandler().close();
        List<Bundle> bundlesToUninstall = Collections.emptyList();
        this.logger.logp(Level.INFO, "OSGiObrModulesRegistryImpl", "shutdown", "bundlesToUninstall = {0}", new Object[]{Arrays.toString(this.getBundleIds(bundlesToUninstall).toArray())});
        for (Bundle bundle2 : bundlesToUninstall) {
            try {
                bundle2.uninstall();
            }
            catch (BundleException e) {
                this.logger.logp(Level.WARNING, "OSGiObrModulesRegistryImpl", "shutdown", "Exception while uninstalling bundle " + bundle2.getBundleId(), e);
            }
        }
        super.shutdown();
    }

    private List<Bundle> getBundlesToUninstall() {
        ArrayList<Bundle> bundlesToUninstall = new ArrayList<Bundle>();
        for (Bundle bundle2 : this.bctx.getBundles()) {
            if (!bundle2.getLocation().startsWith("obr:")) continue;
            bundlesToUninstall.add(bundle2);
        }
        Collections.sort(bundlesToUninstall, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                return (int)(o2.getBundleId() - o1.getBundleId());
            }
        });
        return bundlesToUninstall;
    }

    private List<Long> getBundleIds(List<Bundle> bundlesToUninstall) {
        ArrayList<Long> ids = new ArrayList<Long>(bundlesToUninstall.size());
        for (Bundle bundle2 : bundlesToUninstall) {
            ids.add(bundle2.getBundleId());
        }
        return ids;
    }

    ObrHandler getObrHandler() {
        return this.obrHandler;
    }

    private Bundle getExistingBundle(ModuleDefinition md) {
        String mn = md.getName();
        for (Bundle b : this.bctx.getBundles()) {
            boolean nameMatching;
            String bsn = b.getSymbolicName();
            boolean bl = nameMatching = bsn == mn || bsn != null && bsn.equals(mn);
            if (!nameMatching) continue;
            Version mv = Version.parseVersion((String)md.getVersion());
            Version bv = b.getVersion();
            boolean versionMatching = bv.equals((Object)mv);
            if (!versionMatching) continue;
            return b;
        }
        return null;
    }
}

