/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.Types;

public class Reflections {
    public static final Type[] EMPTY_TYPES = new Type[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];

    private Reflections() {
    }

    public static Map<Class<?>, Type> buildTypeMap(Set<Type> types) {
        HashMap map = new HashMap();
        for (Type type2 : types) {
            Class clazz = Reflections.getRawType(type2);
            if (clazz == null) continue;
            map.put(clazz, type2);
        }
        return map;
    }

    public static boolean isCacheable(Collection<Annotation> annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (Reflections.isTopLevelOrStaticNestedClass(clazz)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCacheable(Annotation[] annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (Reflections.isTopLevelOrStaticNestedClass(clazz)) continue;
            return false;
        }
        return true;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        String get = "get";
        String is = "is";
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring("get".length()));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring("is".length()));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static int getNesting(Class<?> clazz) {
        if (clazz.isMemberClass() && !Reflections.isStatic(clazz)) {
            return 1 + Reflections.getNesting(clazz.getDeclaringClass());
        }
        return 0;
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type2) {
        return Reflections.getNonPrivateFinalMethodOrType(type2) != null;
    }

    public static Object getNonPrivateFinalMethodOrType(Class<?> type2) {
        if (Reflections.isFinal(type2)) {
            return type2;
        }
        for (Class<?> clazz = type2; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : AccessController.doPrivileged(new GetDeclaredMethodsAction(clazz))) {
                if (!Reflections.isFinal(method) || Reflections.isPrivate(method) || Reflections.isStatic(method)) continue;
                return method;
            }
        }
        return null;
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type2) {
        return Modifier.isStatic(type2.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        Type type2 = Types.getCanonicalType(clazz);
        if (type2 instanceof ParameterizedType) {
            return ((ParameterizedType)type2).getActualTypeArguments();
        }
        return EMPTY_TYPES;
    }

    public static Type[] getActualTypeArguments(Type type2) {
        Type resolvedType = Types.getCanonicalType(type2);
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getActualTypeArguments();
        }
        return EMPTY_TYPES;
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type2) {
        return type2.getTypeParameters().length > 0;
    }

    public static boolean isParameterizedTypeWithWildcard(Class<?> type2) {
        return Reflections.isParameterizedType(type2) && Reflections.containsWildcards(type2.getTypeParameters());
    }

    public static boolean containsWildcards(Type[] types) {
        for (Type type2 : types) {
            if (!(type2 instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isBindings(Annotation binding) {
        boolean isBindingAnnotation = false;
        if (binding.annotationType().isAnnotationPresent(Qualifier.class) && binding.annotationType().isAnnotationPresent(Retention.class) && binding.annotationType().getAnnotation(Retention.class).value().equals((Object)RetentionPolicy.RUNTIME)) {
            isBindingAnnotation = true;
        }
        return isBindingAnnotation;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isPrimitive(Type type2) {
        Class rawType = Reflections.getRawType(type2);
        return rawType != null && rawType.isPrimitive();
    }

    public static <T> Class<T> getRawType(Type type2) {
        GenericArrayType genericArrayType;
        Class<T> rawType;
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType && ((ParameterizedType)type2).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        if (type2 instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type2;
            Type[] bounds = variable.getBounds();
            return Reflections.getBound(bounds);
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type2;
            return Reflections.getBound(wildcard.getUpperBounds());
        }
        if (type2 instanceof GenericArrayType && (rawType = Reflections.getRawType((genericArrayType = (GenericArrayType)type2).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }

    private static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return Reflections.getRawType(bounds[0]);
    }

    public static boolean isClassLoadable(String className, ResourceLoader resourceLoader) {
        return Reflections.loadClass(className, resourceLoader) != null;
    }

    public static <T> Class<T> loadClass(String className, ResourceLoader resourceLoader) {
        try {
            return (Class)Reflections.cast(resourceLoader.classForName(className));
        }
        catch (ResourceLoadingException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static boolean isUnboundedWildcard(Type type2) {
        if (type2 instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type2;
            return Reflections.isEmptyBoundArray(wildcard.getUpperBounds()) && Reflections.isEmptyBoundArray(wildcard.getLowerBounds());
        }
        return false;
    }

    public static boolean isUnboundedTypeVariable(Type type2) {
        if (type2 instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type2;
            return Reflections.isEmptyBoundArray(typeVariable.getBounds());
        }
        return false;
    }

    private static boolean isEmptyBoundArray(Type[] bounds) {
        return bounds == null || bounds.length == 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]);
    }

    public static boolean isStaticNestedClass(Class<?> javaClass) {
        if (javaClass.getEnclosingConstructor() != null || javaClass.getEnclosingMethod() != null) {
            return false;
        }
        if (javaClass.getEnclosingClass() != null) {
            if (javaClass.isAnonymousClass()) {
                return false;
            }
            return Reflections.isStatic(javaClass);
        }
        return false;
    }

    public static boolean isTopLevelOrStaticNestedClass(Class<?> javaClass) {
        return javaClass.getEnclosingClass() == null || Reflections.isStaticNestedClass(javaClass);
    }

    public static <T> T invokeAndUnwrap(Object instance, Method method, Object ... parameters) throws Throwable {
        try {
            return Reflections.cast(method.invoke(instance, parameters));
        }
        catch (IllegalArgumentException e) {
            throw ReflectionLogger.LOG.illegalArgumentExceptionOnReflectionInvocation(instance.getClass(), instance, method, Arrays.toString(parameters), e);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static Exception unwrapInvocationTargetException(InvocationTargetException e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        throw new WeldException(cause);
    }
}

