/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.bootstrap.events.AbstractProcessInjectionTarget;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEventPreloader;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeEventResolvable;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanAttributesImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessInjectionPointImpl;
import org.jboss.weld.bootstrap.events.ProcessManagedBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerFieldImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessSessionBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessSyntheticAnnotatedTypeImpl;
import org.jboss.weld.bootstrap.events.RequiredAnnotationDiscovery;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.attributes.FieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ParameterInjectionPointAttributes;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ContainerLifecycleEvents
extends AbstractBootstrapService {
    private boolean everythingObserved;
    private boolean processAnnotatedTypeObserved;
    private boolean processBeanObserved;
    private boolean processBeanAttributesObserved;
    private boolean processInjectionPointObserved;
    private boolean processInjectionTargetObserved;
    private boolean processProducerObserved;
    private boolean processObserverMethodObserved;
    private final RequiredAnnotationDiscovery discovery;
    private final ContainerLifecycleEventPreloader preloader;

    public ContainerLifecycleEvents(ContainerLifecycleEventPreloader preloader, RequiredAnnotationDiscovery discovery) {
        this.preloader = preloader;
        this.discovery = discovery;
    }

    public void processObserverMethod(ObserverMethod<?> observer) {
        if (observer instanceof ExtensionObserverMethodImpl) {
            this.processObserverMethodType(observer.getObservedType());
        }
    }

    protected void processObserverMethodType(Type observedType) {
        if (this.everythingObserved) {
            return;
        }
        Class rawType = Reflections.getRawType(observedType);
        if (Object.class.equals(rawType)) {
            this.everythingObserved = true;
            this.processAnnotatedTypeObserved = true;
            this.processBeanObserved = true;
            this.processBeanAttributesObserved = true;
            this.processInjectionPointObserved = true;
            this.processInjectionTargetObserved = true;
            this.processProducerObserved = true;
            this.processObserverMethodObserved = true;
        } else if (!this.processAnnotatedTypeObserved && ProcessAnnotatedType.class.isAssignableFrom(rawType)) {
            this.processAnnotatedTypeObserved = true;
        } else if (!this.processBeanObserved && ProcessBean.class.isAssignableFrom(rawType)) {
            this.processBeanObserved = true;
        } else if (!this.processBeanAttributesObserved && ProcessBeanAttributes.class.isAssignableFrom(rawType)) {
            this.processBeanAttributesObserved = true;
        } else if (!this.processObserverMethodObserved && ProcessObserverMethod.class.isAssignableFrom(rawType)) {
            this.processObserverMethodObserved = true;
        } else if (!this.processProducerObserved && ProcessProducer.class.equals(rawType)) {
            this.processProducerObserved = true;
        } else if (!this.processInjectionTargetObserved && ProcessInjectionTarget.class.equals(rawType)) {
            this.processInjectionTargetObserved = true;
        } else if (!this.processInjectionPointObserved && ProcessInjectionPoint.class.equals(rawType)) {
            this.processInjectionPointObserved = true;
        }
    }

    public boolean isProcessAnnotatedTypeObserved() {
        return this.processAnnotatedTypeObserved;
    }

    public boolean isProcessBeanObserved() {
        return this.processBeanObserved;
    }

    public boolean isProcessBeanAttributesObserved() {
        return this.processBeanAttributesObserved;
    }

    public boolean isProcessObserverMethodObserved() {
        return this.processObserverMethodObserved;
    }

    public boolean isProcessProducerObserved() {
        return this.processProducerObserved;
    }

    public boolean isProcessInjectionTargetObserved() {
        return this.processInjectionTargetObserved;
    }

    public boolean isProcessInjectionPointObserved() {
        return this.processInjectionPointObserved;
    }

    public <T> ProcessAnnotatedTypeImpl<T> fireProcessAnnotatedType(BeanManagerImpl beanManager, SlimAnnotatedTypeContext<T> annotatedTypeContext) {
        if (!this.isProcessAnnotatedTypeObserved()) {
            return null;
        }
        Set<ExtensionObserverMethodImpl<?, ?>> observers = annotatedTypeContext.getResolvedProcessAnnotatedTypeObservers();
        SlimAnnotatedType<T> annotatedType = annotatedTypeContext.getAnnotatedType();
        if (observers != null && observers.isEmpty()) {
            BootstrapLogger.LOG.patSkipped(annotatedType);
            return null;
        }
        ProcessAnnotatedTypeImpl<T> event = null;
        event = annotatedTypeContext.getExtension() == null ? new ProcessAnnotatedTypeImpl<T>(beanManager, annotatedType) : new ProcessSyntheticAnnotatedTypeImpl<T>(beanManager, annotatedTypeContext);
        if (observers == null) {
            BootstrapLogger.LOG.patDefaultResolver(annotatedType);
            this.fireProcessAnnotatedType(event, beanManager);
        } else {
            BootstrapLogger.LOG.patFastResolver(annotatedType);
            this.fireProcessAnnotatedType(event, annotatedTypeContext.getResolvedProcessAnnotatedTypeObservers());
        }
        return event;
    }

    private void fireProcessAnnotatedType(ProcessAnnotatedTypeImpl<?> event, BeanManagerImpl beanManager) {
        ProcessAnnotatedTypeEventResolvable resolvable = ProcessAnnotatedTypeEventResolvable.of(event, this.discovery);
        try {
            beanManager.getGlobalLenientObserverNotifier().fireEvent(event, resolvable);
        }
        catch (Exception e) {
            throw new DefinitionException(e);
        }
    }

    private void fireProcessAnnotatedType(ProcessAnnotatedTypeImpl<?> event, Set<ExtensionObserverMethodImpl<?, ?>> observers) {
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        for (ExtensionObserverMethodImpl<?, ?> observer : observers) {
            if (!this.checkScopeInheritanceRules(event.getOriginalAnnotatedType(), observer)) continue;
            try {
                observer.notify(event);
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new DefinitionException(errors);
        }
    }

    private boolean checkScopeInheritanceRules(SlimAnnotatedType<?> type2, ExtensionObserverMethodImpl<?, ?> observer) {
        Collection<Class<Annotation>> scopes = observer.getRequiredScopeAnnotations();
        if (!scopes.isEmpty() && scopes.size() == observer.getRequiredScopeAnnotations().size()) {
            for (Class<Annotation> annotation : scopes) {
                if (!type2.isAnnotationPresent(annotation)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void fireProcessBean(BeanManagerImpl beanManager, Bean<?> bean) {
        if (this.isProcessBeanObserved()) {
            if (bean instanceof ManagedBean) {
                ProcessManagedBeanImpl.fire(beanManager, (ManagedBean)bean);
            } else if (bean instanceof SessionBean) {
                ProcessSessionBeanImpl.fire(beanManager, (SessionBean)Reflections.cast(bean));
            } else if (bean instanceof ProducerField) {
                ProcessProducerFieldImpl.fire(beanManager, (ProducerField)bean);
            } else if (bean instanceof ProducerMethod) {
                ProcessProducerMethodImpl.fire(beanManager, (ProducerMethod)bean);
            } else {
                ProcessBeanImpl.fire(beanManager, bean);
            }
        }
    }

    public <T> ProcessBeanAttributesImpl<T> fireProcessBeanAttributes(BeanManagerImpl beanManager, BeanAttributes<T> attributes, Annotated annotated, Type type2) {
        if (this.isProcessBeanAttributesObserved()) {
            return ProcessBeanAttributesImpl.fire(beanManager, attributes, annotated, type2);
        }
        return null;
    }

    public void fireProcessInjectionTarget(BeanManagerImpl beanManager, AbstractClassBean<?> bean) {
        if (this.isProcessInjectionTargetObserved()) {
            AbstractProcessInjectionTarget.fire(beanManager, bean);
        }
    }

    public <X> InjectionTarget<X> fireProcessInjectionTarget(BeanManagerImpl beanManager, AnnotatedType<X> annotatedType, InjectionTarget<X> injectionTarget) {
        if (this.isProcessInjectionTargetObserved()) {
            return AbstractProcessInjectionTarget.fire(beanManager, annotatedType, injectionTarget);
        }
        return injectionTarget;
    }

    public <T, X> FieldInjectionPointAttributes<T, X> fireProcessInjectionPoint(FieldInjectionPointAttributes<T, X> attributes, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        if (this.isProcessInjectionPointObserved()) {
            return ProcessInjectionPointImpl.fire(attributes, declaringComponentClass, manager);
        }
        return attributes;
    }

    public <T, X> ParameterInjectionPointAttributes<T, X> fireProcessInjectionPoint(ParameterInjectionPointAttributes<T, X> injectionPointAttributes, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        if (this.isProcessInjectionPointObserved()) {
            return ProcessInjectionPointImpl.fire(injectionPointAttributes, declaringComponentClass, manager);
        }
        return injectionPointAttributes;
    }

    public void fireProcessObserverMethod(BeanManagerImpl beanManager, ObserverMethod<?> observer) {
        if (this.isProcessObserverMethodObserved()) {
            ProcessObserverMethodImpl.fire(beanManager, observer);
        }
    }

    public void fireProcessProducer(BeanManagerImpl beanManager, AbstractProducerBean<?, ?, Member> bean) {
        if (this.isProcessProducerObserved()) {
            ProcessProducerImpl.fire(beanManager, bean);
        }
    }

    public void preloadProcessAnnotatedType(Class<?> type2) {
        if (this.preloader != null && this.isProcessAnnotatedTypeObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessAnnotatedType.class, type2);
        }
    }

    public <T extends ProcessBean<?>> void preloadProcessBean(Class<T> eventRawType, Type ... typeParameters) {
        if (this.preloader != null && this.isProcessBeanObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessAnnotatedType.class, typeParameters);
        }
    }

    public void preloadProcessBeanAttributes(Type type2) {
        if (this.preloader != null && this.isProcessBeanAttributesObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessBeanAttributes.class, type2);
        }
    }

    public void preloadProcessInjectionPoint(Type ... typeParameters) {
        if (this.preloader != null && this.isProcessInjectionPointObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessInjectionPoint.class, typeParameters);
        }
    }

    public void preloadProcessInjectionTarget(Class<?> type2) {
        if (this.preloader != null && this.isProcessInjectionTargetObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessInjectionTarget.class, type2);
        }
    }

    public void preloadProcessObserverMethod(Type ... typeParameters) {
        if (this.preloader != null && this.isProcessObserverMethodObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessObserverMethod.class, typeParameters);
        }
    }

    public void preloadProcessProducer(Type ... typeParameters) {
        if (this.preloader != null && this.isProcessProducerObserved()) {
            this.preloader.preloadContainerLifecycleEvent(ProcessProducer.class, typeParameters);
        }
    }

    @Override
    public void cleanupAfterBoot() {
        if (this.preloader != null) {
            this.preloader.shutdown();
        }
    }

    public boolean isPreloaderEnabled() {
        return this.preloader != null;
    }
}

