/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class SignatureBuilder {
    public static String fieldAttribute(Type type2) {
        StringBuilder builder = new StringBuilder();
        SignatureBuilder.fieldAttribute(type2, builder);
        return builder.toString();
    }

    private static void fieldAttribute(Type type2, StringBuilder builder) {
        if (type2 instanceof Class) {
            SignatureBuilder.classType((Class)type2, builder);
        } else if (type2 instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type2;
            SignatureBuilder.parametizedType(ptype, builder);
        } else if (type2 instanceof WildcardType) {
            WildcardType ptype = (WildcardType)type2;
            SignatureBuilder.wildcardType(ptype, builder);
        }
    }

    private static void wildcardType(WildcardType type2, StringBuilder builder) {
        builder.append('*');
    }

    public static void parametizedType(ParameterizedType type2, StringBuilder builder) {
        SignatureBuilder.fieldAttribute(type2.getRawType(), builder);
        builder.append('<');
        for (Type t : type2.getActualTypeArguments()) {
            SignatureBuilder.fieldAttribute(t, builder);
            builder.append(';');
        }
        builder.append(">;");
    }

    private static void classType(Class<?> clazz, StringBuilder builder) {
        if (clazz.isMemberClass()) {
            SignatureBuilder.classType(clazz.getDeclaringClass(), builder);
            builder.append('.');
            builder.append(clazz.getSimpleName());
        } else {
            builder.append("L");
            builder.append(clazz.getName().replace('.', '/'));
        }
    }

    private SignatureBuilder() {
    }
}

