/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.util.HashSet;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.context.TypeConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.TypeConstraintMappingContextImpl;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

public class DefaultConstraintMapping
implements ConstraintMapping {
    private static final Log log = LoggerFactory.make();
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions = new AnnotationProcessingOptionsImpl();
    private final Set<Class<?>> configuredTypes = CollectionHelper.newHashSet();
    private final Set<TypeConstraintMappingContextImpl<?>> typeContexts = CollectionHelper.newHashSet();

    @Override
    public final <C> TypeConstraintMappingContext<C> type(Class<C> type2) {
        Contracts.assertNotNull(type2, Messages.MESSAGES.beanTypeMustNotBeNull());
        if (this.configuredTypes.contains(type2)) {
            throw log.getBeanClassHasAlreadyBeConfiguredViaProgrammaticApiException(type2.getName());
        }
        TypeConstraintMappingContextImpl<C> typeContext = new TypeConstraintMappingContextImpl<C>(this, type2);
        this.typeContexts.add(typeContext);
        this.configuredTypes.add(type2);
        return typeContext;
    }

    public final AnnotationProcessingOptionsImpl getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    public Set<Class<?>> getConfiguredTypes() {
        return this.configuredTypes;
    }

    public Set<BeanConfiguration<?>> getBeanConfigurations(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider) {
        HashSet<BeanConfiguration<?>> configurations = CollectionHelper.newHashSet();
        for (TypeConstraintMappingContextImpl<?> typeContext : this.typeContexts) {
            configurations.add(typeContext.build(constraintHelper, parameterNameProvider));
        }
        return configurations;
    }
}

