/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.admin.monitor.JspStatsProvider;
import org.glassfish.web.admin.monitor.RequestStatsProvider;
import org.glassfish.web.admin.monitor.ServletInstanceStatsProvider;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.SessionStatsProvider;
import org.jvnet.hk2.annotations.Service;

@Service(name="web")
@Singleton
public class WebStatsProviderBootstrap
implements PostConstruct {
    private static final String NODE_SEPARATOR = "/";
    @Inject
    private Domain domain;
    private ConcurrentMap<String, ConcurrentMap<String, Queue<Object>>> vsNameToStatsProviderMap = new ConcurrentHashMap<String, ConcurrentMap<String, Queue<Object>>>();
    private Queue<Object> webContainerStatsProviderQueue = new ConcurrentLinkedQueue<Object>();
    private AtomicBoolean isWebStatsProvidersRegistered = new AtomicBoolean(false);

    @Override
    public void postConstruct() {
        this.registerWebStatsProviders();
    }

    private synchronized void registerWebStatsProviders() {
        if (this.isWebStatsProvidersRegistered.get()) {
            return;
        }
        JspStatsProvider jsp = new JspStatsProvider(null, null);
        RequestStatsProvider wsp = new RequestStatsProvider(null, null);
        ServletStatsProvider svsp = new ServletStatsProvider(null, null);
        SessionStatsProvider sssp = new SessionStatsProvider(null, null);
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/jsp", jsp);
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/request", wsp);
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/servlet", svsp);
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/session", sssp);
        this.webContainerStatsProviderQueue.add(jsp);
        this.webContainerStatsProviderQueue.add(wsp);
        this.webContainerStatsProviderQueue.add(svsp);
        this.webContainerStatsProviderQueue.add(sssp);
        this.isWebStatsProvidersRegistered.set(true);
    }

    public void registerApplicationStatsProviders(String monitoringName, String vsName, List<String> servletNames) {
        Queue anotherQueue;
        this.registerWebStatsProviders();
        String node = this.getNodeString(monitoringName, vsName);
        ConcurrentMap<String, ConcurrentLinkedQueue<Object>> statsProviderMap = (ConcurrentHashMap)this.vsNameToStatsProviderMap.get(vsName);
        Queue<SessionStatsProvider> statspList = null;
        if (statsProviderMap == null) {
            statsProviderMap = new ConcurrentHashMap();
            ConcurrentMap anotherMap = this.vsNameToStatsProviderMap.putIfAbsent(vsName, statsProviderMap);
            if (anotherMap != null) {
                statsProviderMap = anotherMap;
            }
        } else {
            statspList = (ConcurrentLinkedQueue<JspStatsProvider>)statsProviderMap.get(monitoringName);
        }
        if (statspList == null && (anotherQueue = (Queue)statsProviderMap.putIfAbsent(monitoringName, (ConcurrentLinkedQueue<Object>)(statspList = new ConcurrentLinkedQueue<JspStatsProvider>()))) != null) {
            statspList = anotherQueue;
        }
        JspStatsProvider jspStatsProvider = new JspStatsProvider(monitoringName, vsName);
        StatsProviderManager.register("web-container", PluginPoint.APPLICATIONS, node, jspStatsProvider);
        statspList.add((SessionStatsProvider)((Object)jspStatsProvider));
        ServletStatsProvider servletStatsProvider = new ServletStatsProvider(monitoringName, vsName);
        StatsProviderManager.register("web-container", PluginPoint.APPLICATIONS, node, servletStatsProvider);
        statspList.add((SessionStatsProvider)((Object)servletStatsProvider));
        SessionStatsProvider sessionStatsProvider = new SessionStatsProvider(monitoringName, vsName);
        StatsProviderManager.register("web-container", PluginPoint.APPLICATIONS, node, sessionStatsProvider);
        statspList.add(sessionStatsProvider);
        RequestStatsProvider websp = new RequestStatsProvider(monitoringName, vsName);
        StatsProviderManager.register("web-container", PluginPoint.APPLICATIONS, node, websp);
        for (String servletName : servletNames) {
            ServletInstanceStatsProvider servletInstanceStatsProvider = new ServletInstanceStatsProvider(servletName, monitoringName, vsName, servletStatsProvider);
            StatsProviderManager.register("web-container", PluginPoint.APPLICATIONS, this.getNodeString(monitoringName, vsName, servletName), servletInstanceStatsProvider);
            statspList.add((SessionStatsProvider)((Object)servletInstanceStatsProvider));
        }
        statspList.add((SessionStatsProvider)((Object)websp));
    }

    public void unregisterApplicationStatsProviders(String monitoringName, String vsName) {
        Map statsProviderMap = (Map)this.vsNameToStatsProviderMap.get(vsName);
        Queue statsProviders = (Queue)statsProviderMap.remove(monitoringName);
        for (Object e : statsProviders) {
            StatsProviderManager.unregister(e);
        }
        if (statsProviderMap.isEmpty()) {
            this.vsNameToStatsProviderMap.remove(vsName);
        }
        if (this.vsNameToStatsProviderMap.isEmpty()) {
            for (Object e : this.webContainerStatsProviderQueue) {
                StatsProviderManager.unregister(e);
            }
            this.webContainerStatsProviderQueue.clear();
            this.isWebStatsProvidersRegistered.set(false);
        }
    }

    private String getNodeString(String moduleName, String ... others) {
        StringBuilder sb = new StringBuilder(moduleName);
        for (String other : others) {
            sb.append(NODE_SEPARATOR).append(other);
        }
        return sb.toString();
    }
}

