/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.api.JavaEEResource;
import org.glassfish.resources.api.ResourcePropertyImpl;
import org.glassfish.resources.beans.CustomResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=org.glassfish.resources.config.CustomResource.class)
@Singleton
public class CustomResourceDeployer
implements ResourceDeployer {
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    private static final StringManager localStrings = StringManager.getManager(CustomResourceDeployer.class);
    @Inject
    private ResourceNamingService cns;
    private static Logger _logger = LogDomains.getLogger(CustomResourceDeployer.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        org.glassfish.resources.config.CustomResource customResource = (org.glassfish.resources.config.CustomResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(customResource.getJndiName(), applicationName, moduleName);
        this.deployResource(resource, resourceInfo);
    }

    @Override
    public synchronized void deployResource(Object resource) throws Exception {
        org.glassfish.resources.config.CustomResource customResource = (org.glassfish.resources.config.CustomResource)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(customResource);
        this.deployResource(customResource, resourceInfo);
    }

    private void deployResource(Object resource, ResourceInfo resourceInfo) {
        org.glassfish.resources.config.CustomResource customRes = (org.glassfish.resources.config.CustomResource)resource;
        JavaEEResource j2eeResource = CustomResourceDeployer.toCustomJavaEEResource(customRes, resourceInfo);
        this.installCustomResource((CustomResource)j2eeResource, resourceInfo);
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        org.glassfish.resources.config.CustomResource customResource = (org.glassfish.resources.config.CustomResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(customResource.getJndiName(), applicationName, moduleName);
        this.deleteResource(customResource, resourceInfo);
    }

    @Override
    public synchronized void undeployResource(Object resource) throws Exception {
        org.glassfish.resources.config.CustomResource customResource = (org.glassfish.resources.config.CustomResource)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(customResource);
        this.deleteResource(customResource, resourceInfo);
    }

    private void deleteResource(org.glassfish.resources.config.CustomResource customResource, ResourceInfo resourceInfo) throws NamingException {
        this.cns.unpublishObject(resourceInfo, resourceInfo.getName());
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.resources.config.CustomResource;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    @Override
    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    @Override
    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installCustomResource(CustomResource customRes, ResourceInfo resourceInfo) {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "installCustomResource by jndi-name : " + resourceInfo);
            }
            Reference ref = new Reference(customRes.getResType(), customRes.getFactoryClass(), null);
            for (ResourceProperty prop : customRes.getProperties()) {
                ref.add(new StringRefAddr(prop.getName(), (String)prop.getValue()));
            }
            this.cns.publishObject(resourceInfo, ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", resourceInfo);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public static JavaEEResource toCustomJavaEEResource(org.glassfish.resources.config.CustomResource rbean, ResourceInfo resourceInfo) {
        CustomResource jr = new CustomResource(resourceInfo);
        jr.setEnabled(Boolean.valueOf(rbean.getEnabled()));
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        List<Property> properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), property.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

