/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.pfl.objectweb.asm.AnnotationVisitor;
import org.glassfish.pfl.objectweb.asm.Attribute;
import org.glassfish.pfl.objectweb.asm.Label;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;
import org.glassfish.pfl.tf.spi.Util;

public class SimpleMethodTracer
implements MethodVisitor {
    final MethodVisitor mv;
    final Util util;
    final Set<Label> visitedLables = new HashSet<Label>();

    private void msg(String str) {
        this.util.info(2, "---" + str);
    }

    public SimpleMethodTracer(MethodVisitor mv, Util util2) {
        this.mv = mv;
        this.util = util2;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.msg("visitAnnotationDefault");
        return this.mv.visitAnnotationDefault();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.msg("visitAnnotation(desc=" + desc + ",visible=" + visible + ")");
        return this.mv.visitAnnotation(desc, visible);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.msg("visitParameterAnnotation(parameter=" + parameter + ".desc=" + desc + ",visible=" + visible + ")");
        return this.mv.visitParameterAnnotation(parameter, desc, visible);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.msg("visitAttribute(attr=" + attr + ")");
        this.mv.visitAttribute(attr);
    }

    @Override
    public void visitCode() {
        this.msg("visitCode");
        this.mv.visitCode();
    }

    private String getFrameType(int type2) {
        switch (type2) {
            case 1: {
                return "APPEND";
            }
            case 2: {
                return "CHOP";
            }
            case 0: {
                return "FULL";
            }
            case -1: {
                return "NEW";
            }
            case 3: {
                return "SAME";
            }
            case 4: {
                return "SAME1";
            }
        }
        return "BAD_FRAME_TYPE";
    }

    @Override
    public void visitFrame(int type2, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.msg("visitFrame(type=" + this.getFrameType(type2) + ",nLocal=" + nLocal + ",local=" + Arrays.asList(local) + ",nStack=" + nStack + ",stack=" + Arrays.asList(stack) + ")");
        this.mv.visitFrame(type2, nLocal, local, nStack, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        this.msg("visitInsn(opcode=" + Util.opcodeToString(opcode) + ")");
        this.mv.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.msg("visitIntInsn(opcode=" + Util.opcodeToString(opcode) + ",operand=" + operand + ")");
        this.mv.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.msg("visitVarInsn(opcode=" + Util.opcodeToString(opcode) + ",var=" + var + ")");
        this.mv.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type2) {
        this.msg("visitTypeInsn(opcode=" + Util.opcodeToString(opcode) + ",type=" + type2 + ")");
        this.mv.visitTypeInsn(opcode, type2);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.msg("visitFieldInsn(opcode=" + Util.opcodeToString(opcode) + ",owner=" + owner + ",name=" + name + ",desc=" + desc + ")");
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.msg("visitMethodInsn(opcode=" + Util.opcodeToString(opcode) + ",owner=" + owner + ",name=" + name + ",desc=" + desc + ")");
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.msg("visitJumpInsn(opcode=" + Util.opcodeToString(opcode) + ",label=" + label + ")");
        this.mv.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.msg("visitLabel(label=" + label + ")");
        this.visitedLables.add(label);
        this.mv.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.msg("visitLdcInsn(cst=" + cst + ")");
        this.mv.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.msg("visitIincInsn(var=" + var + ",increment=" + increment + ")");
        this.mv.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.msg("visitTableSwitchInsn");
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.msg("visitLookupSwitchInsn");
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.msg("visitMultiANewArrayInsn(desc=" + desc + ",dims=" + dims + ")");
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
        this.msg("visitTryCatchBlock(start=" + start + ",end=" + end + ",handler=" + handler + ",type=" + type2 + ")");
        this.mv.visitTryCatchBlock(start, end, handler, type2);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (!this.visitedLables.contains(start)) {
            throw new RuntimeException("visitLocalVariable: start label has not been visited");
        }
        if (!this.visitedLables.contains(end)) {
            throw new RuntimeException("visitLocalVariable: end label has not been visited");
        }
        this.msg("visitLocalVariable(name=" + name + ",desc=" + desc + ",signature=" + signature + ",start=" + start + ",end=" + end + ",index=" + index + ")");
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.msg("visitLineNumber(line=" + line + ",start=" + start + ")");
        this.mv.visitLineNumber(line, start);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.msg("visitMaxs(maxStack=" + maxStack + ",maxLocals=" + maxLocals + ")");
        this.mv.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        this.msg("visitEnd");
        this.mv.visitEnd();
    }
}

