/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.glassfish.pfl.basic.tools.argparser.ArgParser;
import org.glassfish.pfl.basic.tools.argparser.DefaultValue;
import org.glassfish.pfl.basic.tools.argparser.Help;
import org.glassfish.pfl.basic.tools.file.ActionFactory;
import org.glassfish.pfl.basic.tools.file.FileWrapper;
import org.glassfish.pfl.basic.tools.file.Recognizer;
import org.glassfish.pfl.basic.tools.file.Scanner;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerPointSourceGenerator;
import org.glassfish.pfl.tf.timer.spi.TimingInfoProcessor;
import org.glassfish.pfl.tf.tools.enhancer.AnnotationScannerAction;
import org.glassfish.pfl.tf.tools.enhancer.Transformer;

public class EnhanceTool {
    private static int errorCount = 0;
    private Util util;
    private Arguments args;
    private TimingInfoProcessor tip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePropertiesFile(Arguments args, Set<String> anames) throws IOException {
        FileWrapper fw = new FileWrapper(args.rf());
        fw.open(FileWrapper.OpenMode.WRITE_EMPTY);
        try {
            fw.writeLine("# Trace Facility Annotations");
            fw.writeLine("# generated by EnhanceTool on " + new Date());
            fw.writeLine("org.glassfish.tf.annotations.size=" + anames.size());
            int ctr = 1;
            for (String str : anames) {
                String cname = str.replace('/', '.');
                fw.writeLine("org.glassfish.tf.annotation." + ctr + "=" + cname);
                ++ctr;
            }
        }
        finally {
            fw.close();
        }
    }

    private Scanner.Action makeIgnoreAction(final boolean trace) {
        return new Scanner.Action(){

            public String toString() {
                return "ignore action (ignore files that don't match)";
            }

            @Override
            public boolean evaluate(FileWrapper arg) {
                if (trace) {
                    EnhanceTool.this.util.info(1, "Skipping " + arg);
                }
                return true;
            }
        };
    }

    private void doScan(Arguments args, ActionFactory af, Scanner scanner, Scanner.Action classAct) throws IOException {
        Recognizer classRecognizer = af.getRecognizerAction();
        Scanner.Action ignoreAction = this.makeIgnoreAction(args.debug() || args.verbose() > 2);
        classRecognizer.setDefaultAction(ignoreAction);
        classRecognizer.addKnownSuffix("class", classAct);
        scanner.scan(classRecognizer);
    }

    public void run(String[] strs) {
        block8: {
            try {
                ArgParser ap = new ArgParser(Arguments.class);
                this.args = ap.parse(strs, Arguments.class);
                this.util = new Util(this.args.debug(), this.args.verbose());
                String tpname = this.args.timingPointClass();
                String pkg = "";
                String cname = tpname;
                if (tpname.length() > 0) {
                    int index = tpname.lastIndexOf(46);
                    if (index > 0) {
                        cname = tpname.substring(index + 1);
                        pkg = tpname.substring(0, index);
                    }
                } else {
                    cname = "NotUsed";
                    pkg = "no.package";
                }
                this.tip = new TimingInfoProcessor(cname, pkg);
                ActionFactory af = new ActionFactory(0, this.args.dryrun());
                Scanner scanner = new Scanner(0, this.args.dir());
                AnnotationScannerAction annoAct = new AnnotationScannerAction(this.util, this.tip);
                this.doScan(this.args, af, scanner, annoAct);
                Set<String> anames = annoAct.getAnnotationNames();
                if (this.args.debug()) {
                    this.util.info(1, "MM Annotations: " + anames);
                }
                this.generatePropertiesFile(this.args, anames);
                Transformer ea = new Transformer(this.util, this.args.mode(), this.tip, anames);
                EnhancerFileAction act = new EnhancerFileAction(ea);
                this.doScan(this.args, af, scanner, act);
                Pair<String, TimerFactory> res = this.tip.getResult();
                if (!this.args.timingPointDir().equals("")) {
                    TimerPointSourceGenerator.generateFile(this.args.timingPointDir(), res);
                }
            }
            catch (Exception exc) {
                if (this.util == null) {
                    this.util = new Util(true, 1);
                }
                this.util.info(1, "Exception: " + exc);
                if (!this.args.debug()) break block8;
                exc.printStackTrace();
            }
        }
    }

    public static void main(String[] strs) {
        new EnhanceTool().run(strs);
        if (errorCount > 0) {
            System.exit(errorCount);
        }
    }

    private class EnhancerFileAction
    implements Scanner.Action {
        private UnaryFunction<byte[], byte[]> ea;

        public EnhancerFileAction(UnaryFunction<byte[], byte[]> ea) {
            this.ea = ea;
        }

        @Override
        public boolean evaluate(FileWrapper fw) {
            try {
                EnhanceTool.this.util.info(2, "Processing class " + fw.getName());
                byte[] inputData = fw.readAll();
                byte[] outputData = this.ea.evaluate(inputData);
                if (outputData != null) {
                    if (EnhanceTool.this.args.newout()) {
                        String fname = fw.getName() + ".new";
                        EnhanceTool.this.util.info(1, "Writing to class file " + fname);
                        FileWrapper fwo = new FileWrapper(fname);
                        fwo.writeAll(outputData);
                    } else {
                        EnhanceTool.this.util.info(1, "Writing to class file " + fw.getName());
                        fw.writeAll(outputData);
                    }
                }
            }
            catch (Exception exc) {
                EnhanceTool.this.util.info(1, "Exception " + exc + " while processing class " + fw.getName());
                errorCount++;
            }
            return true;
        }
    }

    public static interface Arguments {
        @DefaultValue(value="tfannotations.properties")
        @Help(value="Name of resource file containing information about tf annotations")
        public File rf();

        @DefaultValue(value="false")
        @Help(value="Debug flag")
        public boolean debug();

        @DefaultValue(value="0")
        @Help(value="Verbose flag")
        public int verbose();

        @DefaultValue(value="false")
        @Help(value="Indicates a run that only prints out actions, but does not perform them")
        public boolean dryrun();

        @DefaultValue(value=".")
        @Help(value="Directory to scan for class file")
        public File dir();

        @DefaultValue(value="false")
        @Help(value="If true, write output to a .class.new file")
        public boolean newout();

        @DefaultValue(value="TimingPoints")
        @Help(value="Control the mode of operation: TimingPoints, UpdateSchema, or TraceEnhance")
        public ProcessingMode mode();

        @DefaultValue(value="")
        @Help(value="The timing point class name")
        public String timingPointClass();

        @DefaultValue(value="")
        @Help(value="The directory in which to write the TimingPoint file")
        public String timingPointDir();
    }

    public static enum ProcessingMode {
        TimingPoints,
        UpdateSchemas,
        TraceEnhance;

    }
}

