/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.server.model.internal.ModelHelper;
import org.glassfish.jersey.server.model.internal.ModelProcessorUtil;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.ImplicitViewable;
import org.glassfish.jersey.server.mvc.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.internal.TemplateInflector;

class TemplateModelProcessor
implements ModelProcessor {
    private static final String IMPLICIT_VIEW_PATH_PARAMETER = "implicit-view-path-parameter";
    private static final String IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE = "{implicit-view-path-parameter}";
    private final ResourceContext resourceContext;
    private final Provider<ExtendedUriInfo> extendedUriInfoProvider;
    private final Provider<ConfiguredValidator> validatorProvider;

    @Inject
    TemplateModelProcessor(ResourceContext resourceContext, Provider<ConfiguredValidator> validatorProvider, Provider<ExtendedUriInfo> extendedUriInfoProvider) {
        this.resourceContext = resourceContext;
        this.validatorProvider = validatorProvider;
        this.extendedUriInfoProvider = extendedUriInfoProvider;
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return this.processModel(resourceModel, false);
    }

    @Override
    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return this.processModel(subResourceModel, true);
    }

    private ResourceModel processModel(ResourceModel resourceModel, boolean subResourceModel) {
        ResourceModel.Builder newModelBuilder = this.processTemplateAnnotatedInvocables(resourceModel, subResourceModel);
        for (RuntimeResource resource : resourceModel.getRuntimeResourceModel().getRuntimeResources()) {
            ModelProcessorUtil.enhanceResource(resource, newModelBuilder, this.getEnhancingMethods(resource), false);
        }
        return newModelBuilder.build();
    }

    private ResourceModel.Builder processTemplateAnnotatedInvocables(ResourceModel resourceModel, boolean subResourceModel) {
        ResourceModel.Builder modelBuilder = new ResourceModel.Builder(subResourceModel);
        for (Resource resource : resourceModel.getResources()) {
            Resource newResource = this.processResource(resource);
            modelBuilder.addResource(newResource);
        }
        return modelBuilder;
    }

    private Resource processResource(Resource resource) {
        Resource.Builder resourceBuilder = Resource.builder(resource.getPath());
        for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
            ResourceMethod.Builder builder = resourceBuilder.addMethod(resourceMethod);
            if (!resourceMethod.getInvocable().getHandlingMethod().isAnnotationPresent(Template.class)) continue;
            builder.routingResponseType((Type)((Object)Viewable.class));
        }
        if (resource.getResourceLocator() != null) {
            resourceBuilder.addMethod(resource.getResourceLocator());
        }
        for (Resource child : resource.getChildResources()) {
            resourceBuilder.addChildResource(this.processResource(child));
        }
        return resourceBuilder.build();
    }

    private List<ModelProcessorUtil.Method> getEnhancingMethods(RuntimeResource runtimeResource) {
        final ArrayList<ModelProcessorUtil.Method> newMethods = Lists.newArrayList();
        for (final Resource resource : runtimeResource.getResources()) {
            for (Class<?> handlerClass : resource.getHandlerClasses()) {
                this.createEnhancingMethods(handlerClass, null, newMethods);
            }
            if (resource.getHandlerClasses().isEmpty() && resource.getHandlerInstances().isEmpty()) {
                for (String resourceName : resource.getNames()) {
                    Class resourceClass = AccessController.doPrivileged(ReflectionHelper.classForNamePA(resourceName));
                    if (resourceClass == null) continue;
                    this.createEnhancingMethods(resourceClass, null, newMethods);
                }
            }
            Errors.process(new Producer<Void>(){

                @Override
                public Void call() {
                    for (Object handlerInstance : resource.getHandlerInstances()) {
                        Class<?> handlerInstanceClass = handlerInstance.getClass();
                        if (!resource.getHandlerClasses().contains(handlerInstanceClass)) {
                            TemplateModelProcessor.this.createEnhancingMethods(handlerInstanceClass, handlerInstance, newMethods);
                            continue;
                        }
                        Errors.warning(resource, LocalizationMessages.TEMPLATE_HANDLER_ALREADY_ENHANCED(handlerInstanceClass));
                    }
                    return null;
                }
            });
        }
        return newMethods;
    }

    private void createEnhancingMethods(Class<?> resourceClass, Object resourceInstance, List<ModelProcessorUtil.Method> newMethods) {
        Template template = resourceClass.getAnnotation(Template.class);
        if (template != null) {
            Class<?> annotatedResourceClass = ModelHelper.getAnnotatedResourceClass(resourceClass);
            List<MediaType> produces = MediaTypes.createQualitySourceMediaTypes(annotatedResourceClass.getAnnotation(Produces.class));
            List<MediaType> consumes = MediaTypes.createFrom(annotatedResourceClass.getAnnotation(Consumes.class));
            TemplateInflectorImpl inflector = new TemplateInflectorImpl(template.name(), resourceClass, resourceInstance);
            newMethods.add(new ModelProcessorUtil.Method("GET", consumes, produces, (Inflector<ContainerRequestContext, Response>)inflector));
            newMethods.add(new ModelProcessorUtil.Method(IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE, "GET", consumes, produces, (Inflector<ContainerRequestContext, Response>)inflector));
        }
    }

    private class TemplateInflectorImpl
    implements TemplateInflector,
    Inflector<ContainerRequestContext, Response> {
        private final String templateName;
        private final Class<?> resourceClass;
        private final Object resourceInstance;
        private Class<?> modelClass;

        private TemplateInflectorImpl(String templateName, Class<?> resourceClass, Object resourceInstance) {
            this.templateName = templateName;
            this.resourceClass = resourceClass;
            this.resourceInstance = resourceInstance;
        }

        @Override
        public Response apply(ContainerRequestContext requestContext) {
            List<String> templateNames = this.getTemplateNames(requestContext);
            Object model = this.getModel((ExtendedUriInfo)TemplateModelProcessor.this.extendedUriInfoProvider.get());
            ConfiguredValidator validator = (ConfiguredValidator)TemplateModelProcessor.this.validatorProvider.get();
            if (validator != null) {
                validator.validateResourceAndInputParams(model, null, null);
            }
            return Response.ok().entity(new ImplicitViewable(templateNames, model, this.resourceClass)).build();
        }

        @Override
        public Class<?> getModelClass() {
            return this.modelClass;
        }

        private Object setModelClass(Object model) {
            if (this.modelClass == null) {
                this.modelClass = model.getClass();
            }
            return model;
        }

        private Object getModel(ExtendedUriInfo extendedUriInfo) {
            List<Object> matchedResources = extendedUriInfo.getMatchedResources();
            if (this.resourceInstance != null) {
                return this.setModelClass(this.resourceInstance);
            }
            if (matchedResources.size() > 1) {
                return this.setModelClass(matchedResources.get(1));
            }
            return this.setModelClass(TemplateModelProcessor.this.resourceContext.getResource(this.resourceClass));
        }

        private List<String> getTemplateNames(ContainerRequestContext requestContext) {
            RuntimeResource lastMatchedRuntimeResource;
            Resource lastMatchedResource;
            String path;
            ExtendedUriInfo uriInfo;
            List<RuntimeResource> matchedRuntimeResources;
            ArrayList<String> templateNames = Lists.newArrayList();
            String pathTemplate = requestContext.getUriInfo().getPathParameters().getFirst(TemplateModelProcessor.IMPLICIT_VIEW_PATH_PARAMETER);
            if (pathTemplate != null) {
                templateNames.add(pathTemplate);
            }
            if (this.templateName != null && !"".equals(this.templateName)) {
                templateNames.add(this.templateName);
            }
            if ((matchedRuntimeResources = (uriInfo = (ExtendedUriInfo)TemplateModelProcessor.this.extendedUriInfoProvider.get()).getMatchedRuntimeResources()).size() > 1 && (path = (lastMatchedResource = (lastMatchedRuntimeResource = matchedRuntimeResources.get(0)).getResources().get(0)).getPath()) != null && !TemplateModelProcessor.IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE.equals(path)) {
                path = path.charAt(0) == '/' ? path.substring(1, path.length()) : path;
                templateNames.add(path);
            }
            if (templateNames.isEmpty()) {
                templateNames.add("index");
            }
            return templateNames;
        }
    }
}

