/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.compression.HeaderListener;
import org.glassfish.grizzly.http2.hpack.BinaryPrimitives;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentation;
import org.glassfish.grizzly.http2.hpack.HeaderField;
import org.glassfish.grizzly.http2.hpack.HeaderFieldTable;
import org.glassfish.grizzly.http2.hpack.ObjectHolder;

public class Literal
implements BinaryRepresentation {
    public static final Literal getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private Literal() {
    }

    public static boolean matches(byte sig) {
        return (sig & 0xF0) == 0;
    }

    @Override
    public void process(Buffer source, HeaderFieldTable.DecTable table, HeaderListener handler) {
        String name;
        ObjectHolder<String> s = new ObjectHolder<String>();
        int beginning = source.position();
        byte b = source.get();
        if ((b & 0xF) == 0) {
            BinaryPrimitives.readString(source, s);
            name = s.getObj();
        } else {
            source.position(beginning);
            int index = BinaryPrimitives.readInteger(source, 7);
            HeaderField e = table.get(index);
            name = e.getName();
        }
        BinaryPrimitives.readString(source, s);
        String value = s.getObj();
        handler.onDecodedHeader(name, value);
    }

    public static void write(int index, String value, OutputStream destination, boolean useHuffman) throws IOException {
        BinaryPrimitives.writeInteger(destination, index, 4, 0);
        BinaryPrimitives.writeString(destination, value, useHuffman);
    }

    public static void write(String name, String value, OutputStream destination, boolean useHuffman) throws IOException {
        BinaryPrimitives.writeInteger(destination, 0, 4, 0);
        BinaryPrimitives.writeString(destination, name, useHuffman);
        BinaryPrimitives.writeString(destination, value, useHuffman);
    }

    private static class InstanceHolder {
        private static final Literal INSTANCE = new Literal();

        private InstanceHolder() {
        }
    }
}

