/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2FrameCodec;

class Http2State {
    private static final Attribute<Http2State> http2State = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(Http2State.class.getName() + ".state");
    private final AtomicReference<Status> status = new AtomicReference();
    private final Http2FrameCodec.FrameParsingState frameParsingState = new Http2FrameCodec.FrameParsingState();
    private Http2Connection http2Connection;
    private boolean isClientHttpUpgradeRequestFinished;
    private boolean isClientPrefaceSent;

    static Http2State getOrCreate(Connection connection, DraftVersion version) {
        Http2State state = http2State.get(connection);
        if (state == null) {
            state = new Http2State();
            http2State.set(connection, state);
        }
        return state;
    }

    static Http2State get(Connection connection) {
        return http2State.get(connection);
    }

    static boolean isHttp2(Connection connection) {
        Http2State state = http2State.get(connection);
        return state != null && state.isHttp2();
    }

    static Http2State obtain(Connection connection) {
        Http2State state = http2State.get(connection);
        if (state == null) {
            state = Http2State.create(connection);
        }
        return state;
    }

    static Http2State create(Connection connection) {
        Http2State state = new Http2State();
        http2State.set(connection, state);
        return state;
    }

    static void remove(Connection connection) {
        http2State.remove(connection);
    }

    public Http2State() {
        this.status.set(Status.HTTP_UPGRADE);
    }

    public Status getStatus() {
        return this.status.get();
    }

    boolean isNeverHttp2() {
        return this.status.get() == Status.NEVER_HTTP2;
    }

    void setNeverHttp2() {
        this.status.set(Status.NEVER_HTTP2);
    }

    boolean isHttp2() {
        return !this.isNeverHttp2();
    }

    boolean isReady() {
        return this.status.get() == Status.OPEN;
    }

    void setOpen() {
        this.status.set(Status.OPEN);
    }

    boolean isUpgradePhase() {
        Status statusLocal = this.status.get();
        return statusLocal == Status.HTTP_UPGRADE || statusLocal == Status.DIRECT_UPGRADE;
    }

    boolean isHttpUpgradePhase() {
        return this.status.get() == Status.HTTP_UPGRADE;
    }

    void finishHttpUpgradePhase() {
        this.status.compareAndSet(Status.HTTP_UPGRADE, Status.DIRECT_UPGRADE);
    }

    boolean isDirectUpgradePhase() {
        return this.status.get() == Status.DIRECT_UPGRADE;
    }

    void setDirectUpgradePhase() {
        this.status.set(Status.DIRECT_UPGRADE);
    }

    Http2FrameCodec.FrameParsingState getFrameParsingState() {
        return this.frameParsingState;
    }

    Http2Connection getHttp2Connection() {
        return this.http2Connection;
    }

    void setHttp2Connection(Http2Connection http2Connection) {
        this.http2Connection = http2Connection;
        this.http2Connection.http2State = this;
    }

    void onClientHttpUpgradeRequestFinished() {
        this.isClientHttpUpgradeRequestFinished = true;
    }

    synchronized boolean tryLockClientPreface() {
        Status s = this.status.get();
        if (!this.isClientPrefaceSent && this.isClientHttpUpgradeRequestFinished && (s == Status.DIRECT_UPGRADE || s == Status.OPEN)) {
            this.isClientPrefaceSent = true;
            return true;
        }
        return false;
    }

    public static enum Status {
        NEVER_HTTP2,
        HTTP_UPGRADE,
        DIRECT_UPGRADE,
        OPEN;

    }
}

