/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http2.AlpnClientNegotiatorImpl;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.Constants;
import org.glassfish.grizzly.http2.DecoderUtils;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PushPromiseFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;
import org.glassfish.grizzly.ssl.SSLFilter;

public class Http2ClientFilter
extends Http2BaseFilter {
    private final AlpnClientNegotiatorImpl defaultClientAlpnNegotiator;
    private boolean isNeverForceUpgrade;
    private boolean sendPushRequestUpstream;
    private final HeaderValue defaultHttp2DraftUpgrade;
    private final HeaderValue connectionUpgradeHeaderValue;

    public Http2ClientFilter() {
        this((ExecutorService)null, ALL_HTTP2_DRAFTS);
    }

    public Http2ClientFilter(DraftVersion ... supportedDraftVersions) {
        this((ExecutorService)null, supportedDraftVersions);
    }

    public Http2ClientFilter(ExecutorService threadPool, DraftVersion ... supportedDraftVersions) {
        super(threadPool, supportedDraftVersions);
        this.defaultClientAlpnNegotiator = new AlpnClientNegotiatorImpl(supportedDraftVersions, this);
        this.defaultHttp2DraftUpgrade = HeaderValue.newHeaderValue(this.getSupportedHttp2Drafts()[0].getClearTextId());
        this.connectionUpgradeHeaderValue = HeaderValue.newHeaderValue("Upgrade, HTTP2-Settings");
    }

    public boolean isNeverForceUpgrade() {
        return this.isNeverForceUpgrade;
    }

    public void setNeverForceUpgrade(boolean neverForceUpgrade) {
        this.isNeverForceUpgrade = neverForceUpgrade;
    }

    public boolean isSendPushRequestUpstream() {
        return this.sendPushRequestUpstream;
    }

    public void setSendPushRequestUpstream(boolean sendPushRequestUpstream) {
        this.sendPushRequestUpstream = sendPushRequestUpstream;
    }

    @Override
    public NextAction handleConnect(final FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        FilterChain filterChain = (FilterChain)connection.getProcessor();
        int idx = filterChain.indexOfType(SSLFilter.class);
        if (idx != -1) {
            SSLFilter sslFilter = (SSLFilter)filterChain.get(idx);
            AlpnSupport.getInstance().configure(sslFilter);
            AlpnSupport.getInstance().setClientSideNegotiator(connection, this.getClientAlpnNegotioator());
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.suspend();
            sslFilter.handshake(connection, (CompletionHandler<SSLEngine>)new EmptyCompletionHandler<SSLEngine>(){

                @Override
                public void completed(SSLEngine result) {
                    ctx.resumeNext();
                }

                @Override
                public void failed(Throwable throwable) {
                    ctx.fail(throwable);
                }
            });
            connection.enableIOEvent(IOEvent.READ);
            return suspendAction;
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        if (this.checkIfHttp2StreamChain(ctx)) {
            return ctx.getInvokeAction();
        }
        Connection connection = ctx.getConnection();
        Http2State http2State = Http2State.get(connection);
        if (http2State == null || http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        HttpHeader httpHeader = httpContent.getHttpHeader();
        if (http2State.isHttpUpgradePhase()) {
            assert (!httpHeader.isRequest());
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpHeader;
            HttpRequestPacket httpRequest = httpResponse.getRequest();
            if (!this.tryHttpUpgrade(ctx, http2State, httpRequest, httpResponse)) {
                http2State.setNeverHttp2();
                return ctx.getInvokeAction();
            }
        }
        assert (http2State != null);
        Http2Connection http2Connection = this.obtainHttp2Connection(http2State, ctx, true);
        Buffer framePayload = httpContent.getContent();
        httpContent.recycle();
        List<Http2Frame> framesList = this.frameCodec.parse(http2Connection, http2State.getFrameParsingState(), framePayload);
        if (!this.processFrames(ctx, http2Connection, framesList)) {
            return ctx.getSuspendAction();
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Http2State http2State = Http2State.get(connection);
        if (http2State != null && http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        if (http2State == null) {
            http2State = Http2State.create(connection);
            Object msg = ctx.getMessage();
            if (!this.tryInsertHttpUpgradeHeaders(connection, msg)) {
                http2State.setNeverHttp2();
            }
            assert (HttpPacket.isHttp(ctx.getMessage()));
            this.checkIfLastHttp11Chunk(ctx, http2State, msg);
            return ctx.getInvokeAction();
        }
        if (http2State.isHttpUpgradePhase()) {
            Object msg = ctx.getMessage();
            if (HttpPacket.isHttp(msg)) {
                if (!((HttpPacket)msg).getHttpHeader().isCommitted()) {
                    throw new IllegalStateException("Can't pipeline HTTP requests because it's still not clear if HTTP/1.x or HTTP/2 will be used");
                }
                this.checkIfLastHttp11Chunk(ctx, http2State, msg);
            }
            return ctx.getInvokeAction();
        }
        return super.handleWrite(ctx);
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (!Http2State.isHttp2(ctx.getConnection())) {
            return ctx.getInvokeAction();
        }
        Object type2 = event.type();
        if (type2 == HttpEvents.OutgoingHttpUpgradeEvent.TYPE) {
            assert (event instanceof HttpEvents.OutgoingHttpUpgradeEvent);
            HttpEvents.OutgoingHttpUpgradeEvent outUpgradeEvent = (HttpEvents.OutgoingHttpUpgradeEvent)event;
            outUpgradeEvent.getHttpHeader().setIgnoreContentModifiers(false);
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    protected Http2Connection createClientHttp2Connection(DraftVersion draftVersion, Connection connection) {
        return this.createHttp2Connection(draftVersion, connection, false);
    }

    protected AlpnClientNegotiator getClientAlpnNegotioator() {
        return this.defaultClientAlpnNegotiator;
    }

    private boolean tryHttpUpgrade(FilterChainContext ctx, Http2State http2State, HttpRequestPacket httpRequest, HttpResponsePacket httpResponse) throws Http2StreamException, IOException {
        if (httpRequest == null) {
            return false;
        }
        if (!this.checkRequestHeadersOnUpgrade(httpRequest)) {
            return false;
        }
        if (!this.checkResponseHeadersOnUpgrade(httpResponse)) {
            return false;
        }
        DraftVersion requestVersion = this.getHttp2UpgradingVersion(httpRequest);
        DraftVersion responseVersion = this.getHttp2UpgradingVersion(httpResponse);
        if (requestVersion == null || requestVersion != responseVersion) {
            throw new IOException("HTTP2 handshake failed: HTTP2 versions mismatch");
        }
        DraftVersion version = requestVersion;
        Connection connection = ctx.getConnection();
        http2State.setDirectUpgradePhase();
        Http2Connection http2Connection = this.createClientHttp2Connection(version, connection);
        if (http2State.tryLockClientPreface()) {
            http2Connection.sendPreface();
        }
        http2Connection.setupFilterChains(ctx, true);
        httpResponse.setStatus(HttpStatus.OK_200);
        httpResponse.getHeaders().clear();
        httpRequest.setProtocol(Protocol.HTTP_2_0);
        httpResponse.setProtocol(Protocol.HTTP_2_0);
        httpResponse.getUpgradeDC().recycle();
        httpResponse.getProcessingState().setKeepAlive(true);
        Http2Stream stream = http2Connection.openUpgradeStream(httpRequest, 0, true);
        HttpContext oldHttpContext = httpResponse.getProcessingState().getHttpContext();
        HttpContext httpContext = HttpContext.newInstance(stream, stream, stream, httpRequest);
        httpRequest.getProcessingState().setHttpContext(httpContext);
        httpContext.attach(ctx);
        HttpRequestPacket dummyRequestPacket = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PRI).uri("/dummy_pri").protocol(Protocol.HTTP_2_0)).build();
        HttpResponsePacket dummyResponsePacket = ((HttpResponsePacket.Builder)HttpResponsePacket.builder(dummyRequestPacket).status(200).reasonPhrase("OK").protocol(Protocol.HTTP_2_0)).build();
        dummyResponsePacket.getProcessingState().setHttpContext(oldHttpContext);
        dummyResponsePacket.setIgnoreContentModifiers(true);
        ctx.notifyDownstream(HttpEvents.createChangePacketInProgressEvent(dummyResponsePacket));
        return true;
    }

    private boolean tryInsertHttpUpgradeHeaders(Connection connection, Object msg) {
        if (this.isNeverForceUpgrade) {
            return false;
        }
        if (!HttpPacket.isHttp(msg)) {
            return false;
        }
        HttpHeader httpHeader = ((HttpPacket)msg).getHttpHeader();
        if (!httpHeader.isRequest() || !httpHeader.getUpgradeDC().isNull() || httpHeader.getProtocol() != Protocol.HTTP_1_1 || httpHeader.containsHeader(Header.Connection)) {
            return false;
        }
        httpHeader.addHeader(Header.Upgrade, this.defaultHttp2DraftUpgrade);
        httpHeader.addHeader(Header.Connection, this.connectionUpgradeHeaderValue);
        httpHeader.addHeader(Header.HTTP2Settings, this.prepareSettings().build().toBase64Uri());
        return true;
    }

    @Override
    protected void processCompleteHeader(Http2Connection http2Connection, FilterChainContext context, HeaderBlockHead firstHeaderFrame) throws IOException {
        if (firstHeaderFrame.getType() == 5) {
            assert (!http2Connection.isServer());
            this.processInPushPromise(http2Connection, context, (PushPromiseFrame)firstHeaderFrame);
        } else {
            super.processCompleteHeader(http2Connection, context, firstHeaderFrame);
        }
    }

    private void processInPushPromise(Http2Connection http2Connection, FilterChainContext context, PushPromiseFrame pushPromiseFrame) throws Http2StreamException, IOException {
        Http2Request request = Http2Request.create();
        request.setConnection(context.getConnection());
        int refStreamId = pushPromiseFrame.getStreamId();
        Http2Stream refStream = http2Connection.getStream(refStreamId);
        if (refStream == null) {
            throw new Http2StreamException(refStreamId, ErrorCode.REFUSED_STREAM, "PushPromise is sent over unknown stream: " + refStreamId);
        }
        Http2Stream stream = http2Connection.acceptStream(request, pushPromiseFrame.getPromisedStreamId(), refStreamId, 0);
        if (stream == null) {
            request.recycle();
            return;
        }
        DecoderUtils.decodeRequestHeaders(http2Connection, request);
        this.onHttpHeadersParsed(request, context);
        this.prepareIncomingRequest(stream, request);
        refStream.onHeaderBlockRcv(pushPromiseFrame);
        stream.outputSink.terminate(Constants.OUT_FIN_TERMINATION);
        if (this.sendPushRequestUpstream) {
            this.sendUpstream(http2Connection, stream, request, false);
        }
    }

    protected final SettingsFrame.SettingsFrameBuilder prepareSettings() {
        return this.prepareSettings(this.getSupportedHttp2Drafts()[0], null);
    }

    protected final SettingsFrame.SettingsFrameBuilder prepareSettings(DraftVersion version) {
        return this.prepareSettings(version, null);
    }

    protected SettingsFrame.SettingsFrameBuilder prepareSettings(DraftVersion version, SettingsFrame.SettingsFrameBuilder builder) {
        int initWindSize;
        int maxConcStreams;
        if (builder == null) {
            builder = SettingsFrame.builder();
        }
        if (version == null) {
            version = this.getSupportedHttp2Drafts()[0];
        }
        if ((maxConcStreams = this.getMaxConcurrentStreams()) != -1 && maxConcStreams != version.getDefaultMaxConcurrentStreams()) {
            builder.setting(3, maxConcStreams);
        }
        if ((initWindSize = this.getInitialWindowSize()) != -1 && initWindSize != version.getDefaultStreamWindowSize()) {
            builder.setting(4, initWindSize);
        }
        return builder;
    }

    private void checkIfLastHttp11Chunk(FilterChainContext ctx, Http2State http2State, Object msg) {
        if (HttpContent.isContent((HttpPacket)msg) && ((HttpContent)msg).isLast()) {
            http2State.onClientHttpUpgradeRequestFinished();
            final Http2State finalState = http2State;
            ctx.addCompletionListener(new FilterChainContext.CompletionListener(){

                @Override
                public void onComplete(FilterChainContext context) {
                    if (finalState.tryLockClientPreface()) {
                        Http2Connection http2Connection = finalState.getHttp2Connection();
                        assert (http2Connection != null);
                        http2Connection.sendPreface();
                    }
                }
            });
        }
    }
}

