/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.FixedLengthTransferEncoding;
import org.glassfish.grizzly.http.HttpBaseFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.Constants;
import org.glassfish.grizzly.http2.DecoderUtils;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2ConnectionException;
import org.glassfish.grizzly.http2.Http2FrameCodec;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2Response;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.PushResource;
import org.glassfish.grizzly.http2.Source;
import org.glassfish.grizzly.http2.compression.HeadersDecoder;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.GoAwayFrame;
import org.glassfish.grizzly.http2.frames.HeaderBlockFragment;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PingFrame;
import org.glassfish.grizzly.http2.frames.RstStreamFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.http2.frames.WindowUpdateFrame;
import org.glassfish.grizzly.threadpool.Threads;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.Pair;

public class Http2BaseFilter
extends HttpBaseFilter {
    private static final Logger LOGGER = Grizzly.logger(Http2BaseFilter.class);
    private static final TransferEncoding FIXED_LENGTH_ENCODING = new FixedLengthTransferEncoding();
    static final String HTTP2_CLEAR_TCP_UPGRADE_SIGNATURE = "h2c";
    static final DraftVersion[] ALL_HTTP2_DRAFTS = new DraftVersion[]{DraftVersion.DRAFT_14};
    static final byte[] PRI_MSG = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(Charsets.ASCII_CHARSET);
    static final byte[] PRI_PAYLOAD = "SM\r\n\r\n".getBytes(Charsets.ASCII_CHARSET);
    final Http2FrameCodec frameCodec = new Http2FrameCodec();
    private final DraftVersion[] supportedHttp2Drafts;
    private final ExecutorService threadPool;
    private volatile int maxConcurrentStreams = -1;
    private volatile int initialWindowSize = -1;
    private int localMaxFramePayloadSize;

    public Http2BaseFilter() {
        this((ExecutorService)null, ALL_HTTP2_DRAFTS);
    }

    public Http2BaseFilter(DraftVersion ... supportedDraftVersions) {
        this((ExecutorService)null, supportedDraftVersions);
    }

    public Http2BaseFilter(ExecutorService threadPool, DraftVersion ... supportedDraftVersions) {
        this.threadPool = threadPool;
        this.supportedHttp2Drafts = supportedDraftVersions == null || supportedDraftVersions.length == 0 ? Arrays.copyOf(ALL_HTTP2_DRAFTS, ALL_HTTP2_DRAFTS.length) : Arrays.copyOf(supportedDraftVersions, supportedDraftVersions.length);
    }

    public int getLocalMaxFramePayloadSize() {
        return this.localMaxFramePayloadSize;
    }

    public void setLocalMaxFramePayloadSize(int localMaxFramePayloadSize) {
        this.localMaxFramePayloadSize = localMaxFramePayloadSize;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFrames(FilterChainContext ctx, Http2Connection http2Connection, List<Http2Frame> framesList) {
        if (framesList == null || framesList.isEmpty()) {
            return true;
        }
        try {
            try {
                for (Http2Frame inFrame : framesList) {
                    try {
                        this.processInFrame(http2Connection, ctx, inFrame);
                    }
                    catch (Http2StreamException e) {
                        int streamId;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Http2StreamException occurred on connection=" + ctx.getConnection() + " during Http2Frame processing", e);
                        }
                        if ((streamId = e.getStreamId()) == 0) {
                            throw new Http2ConnectionException(ErrorCode.PROTOCOL_ERROR);
                        }
                        this.sendRstStream(ctx, http2Connection, streamId, e.getErrorCode());
                    }
                }
            }
            finally {
                framesList.clear();
            }
            List<Http2Stream> streamsToFlushInput = http2Connection.streamsToFlushInput;
            for (Http2Stream streamsToFlush : streamsToFlushInput) {
                streamsToFlush.flushInputData();
            }
            streamsToFlushInput.clear();
            return true;
        }
        catch (Http2ConnectionException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Http2ConnectionException occurred on connection=" + ctx.getConnection() + " during Http2Frame processing", e);
            }
            this.sendGoAwayAndClose(ctx, http2Connection, e.getErrorCode());
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException occurred on connection=" + ctx.getConnection() + " during Http2Frame processing", e);
            }
            this.sendGoAwayAndClose(ctx, http2Connection, ErrorCode.INTERNAL_ERROR);
        }
        return false;
    }

    DraftVersion[] getSupportedHttp2Drafts() {
        return this.supportedHttp2Drafts;
    }

    protected boolean checkRequestHeadersOnUpgrade(HttpRequestPacket httpRequest) {
        if (httpRequest.getUpgradeDC().isNull()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed no upgrade");
            }
            return false;
        }
        DataChunk connectionHeaderDC = httpRequest.getHeaders().getValue(Header.Connection);
        if (connectionHeaderDC == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed no connection");
            }
            return false;
        }
        boolean upgradeFound = false;
        boolean http2SettingsFound = false;
        int pos = 0;
        int len = connectionHeaderDC.getLength();
        while (pos < len) {
            int comma = connectionHeaderDC.indexOf(",", pos);
            int valueEnd = comma != -1 ? comma : len;
            String value = connectionHeaderDC.toString(pos, valueEnd).trim();
            upgradeFound = upgradeFound || "Upgrade".equals(value);
            http2SettingsFound = http2SettingsFound || "HTTP2-Settings".equals(value);
            pos = valueEnd + 1;
        }
        if (!upgradeFound || !http2SettingsFound) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed incorrect connection: " + connectionHeaderDC);
            }
            return false;
        }
        if (!httpRequest.getHeaders().contains(Header.HTTP2Settings)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed no settings");
            }
            return false;
        }
        return true;
    }

    protected boolean checkResponseHeadersOnUpgrade(HttpResponsePacket httpResponse) {
        if (httpResponse.getStatus() != 101) {
            return false;
        }
        if (httpResponse.getUpgradeDC().isNull()) {
            return false;
        }
        DataChunk connectionHeaderDC = httpResponse.getHeaders().getValue(Header.Connection);
        return connectionHeaderDC != null && !connectionHeaderDC.isNull() && connectionHeaderDC.equals(Header.Upgrade.getBytes());
    }

    protected SettingsFrame getHttp2UpgradeSettings(HttpRequestPacket httpRequest) {
        DataChunk http2Settings = httpRequest.getHeaders().getValue(Header.HTTP2Settings);
        return http2Settings != null ? SettingsFrame.fromBase64Uri(http2Settings) : null;
    }

    protected DraftVersion getHttp2UpgradingVersion(HttpHeader httpHeader) {
        DataChunk upgradeDC = httpHeader.getUpgradeDC();
        assert (upgradeDC != null && !upgradeDC.isNull());
        if (!upgradeDC.startsWith(HTTP2_CLEAR_TCP_UPGRADE_SIGNATURE, 0)) {
            return null;
        }
        int versionOffs = HTTP2_CLEAR_TCP_UPGRADE_SIGNATURE.length() + 1;
        int versionLen = upgradeDC.getLength() - versionOffs;
        String version = versionLen <= 0 ? "0" : upgradeDC.toString(versionOffs, versionOffs + versionLen);
        DraftVersion foundVersion = null;
        for (DraftVersion draft : this.getSupportedHttp2Drafts()) {
            if (!draft.getVersion().equals(version)) continue;
            foundVersion = draft;
        }
        return foundVersion;
    }

    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        return false;
    }

    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        return false;
    }

    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onInitialLineEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
    }

    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
    }

    private void processInFrame(Http2Connection http2Connection, FilterChainContext context, Http2Frame frame) throws Http2StreamException, Http2ConnectionException, IOException {
        http2Connection.checkFrameSequenceSemantics(frame);
        switch (frame.getType()) {
            case 0: {
                Http2BaseFilter.processDataFrame(http2Connection, context, (DataFrame)frame);
                break;
            }
            case 2: {
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                this.processHeadersFrame(http2Connection, context, frame);
                break;
            }
            case 4: {
                this.processSettingsFrame(http2Connection, context, frame);
                break;
            }
            case 6: {
                this.processPingFrame(http2Connection, frame);
                break;
            }
            case 3: {
                this.processRstStreamFrame(http2Connection, frame);
                break;
            }
            case 7: {
                this.processGoAwayFrame(http2Connection, frame);
                break;
            }
            case 8: {
                this.processWindowUpdateFrame(http2Connection, frame);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Unknown or unhandled frame [type={0} flags={1} length={2} streamId={3}]", new Object[]{frame.getType(), frame.getFlags(), frame.getLength(), frame.getStreamId()});
            }
        }
    }

    private void processWindowUpdateFrame(Http2Connection http2Connection, Http2Frame frame) throws Http2StreamException {
        WindowUpdateFrame updateFrame = (WindowUpdateFrame)frame;
        int streamId = updateFrame.getStreamId();
        int delta = updateFrame.getWindowSizeIncrement();
        if (streamId == 0) {
            http2Connection.getOutputSink().onPeerWindowUpdate(delta);
        } else {
            Http2Stream stream = http2Connection.getStream(streamId);
            if (stream != null) {
                stream.getOutputSink().onPeerWindowUpdate(delta);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder(64);
                sb.append("\nStream id=").append(streamId).append(" was not found. Ignoring the message.");
                LOGGER.fine(sb.toString());
            }
        }
    }

    private void processGoAwayFrame(Http2Connection http2Connection, Http2Frame frame) {
        GoAwayFrame goAwayFrame = (GoAwayFrame)frame;
        http2Connection.setGoAwayByPeer(goAwayFrame.getLastStreamId());
    }

    private void processSettingsFrame(Http2Connection http2Connection, FilterChainContext context, Http2Frame frame) throws Http2ConnectionException {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        if (settingsFrame.isAck()) {
            return;
        }
        this.applySettings(http2Connection, settingsFrame);
        this.sendSettingsAck(http2Connection, context);
    }

    void applySettings(Http2Connection http2Connection, SettingsFrame settingsFrame) throws Http2ConnectionException {
        int numberOfSettings = settingsFrame.getNumberOfSettings();
        block7: for (int i = 0; i < numberOfSettings; ++i) {
            SettingsFrame.Setting setting = settingsFrame.getSettingByIndex(i);
            switch (setting.getId()) {
                case 1: {
                    continue block7;
                }
                case 2: {
                    continue block7;
                }
                case 3: {
                    http2Connection.setPeerMaxConcurrentStreams(setting.getValue());
                    continue block7;
                }
                case 4: {
                    http2Connection.setPeerStreamWindowSize(setting.getValue());
                    continue block7;
                }
                case 5: {
                    http2Connection.setPeerMaxFramePayloadSize(setting.getValue());
                    continue block7;
                }
            }
        }
    }

    private void processPingFrame(Http2Connection http2Connection, Http2Frame frame) {
        PingFrame pingFrame = (PingFrame)frame;
        pingFrame.setFlag(1);
        http2Connection.getOutputSink().writeDownStream(pingFrame);
    }

    private void processRstStreamFrame(Http2Connection http2Connection, Http2Frame frame) {
        RstStreamFrame rstFrame = (RstStreamFrame)frame;
        int streamId = rstFrame.getStreamId();
        Http2Stream stream = http2Connection.getStream(streamId);
        if (stream == null) {
            frame.recycle();
            return;
        }
        stream.resetRemotely();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeadersFrame(Http2Connection http2Connection, FilterChainContext context, Http2Frame frame) throws IOException {
        HeaderBlockFragment headerFragment = (HeaderBlockFragment)frame;
        HeadersDecoder headersDecoder = http2Connection.getHeadersDecoder();
        if (headerFragment.getCompressedHeaders().hasRemaining()) {
            headersDecoder.append(headerFragment.takePayload());
        }
        boolean isEOH = headerFragment.isEndHeaders();
        if (!headersDecoder.isProcessingHeaders()) {
            headersDecoder.setFirstHeaderFrame((HeaderBlockHead)headerFragment);
        } else {
            headerFragment.recycle();
        }
        if (!isEOH) {
            return;
        }
        HeaderBlockHead firstHeaderFrame = headersDecoder.finishHeader();
        try {
            this.processCompleteHeader(http2Connection, context, firstHeaderFrame);
        }
        finally {
            firstHeaderFrame.recycle();
        }
    }

    protected void processCompleteHeader(Http2Connection http2Connection, FilterChainContext context, HeaderBlockHead firstHeaderFrame) throws IOException {
        assert (firstHeaderFrame.getType() == 1);
        if (http2Connection.isServer()) {
            this.processInRequest(http2Connection, context, (HeadersFrame)firstHeaderFrame);
        } else {
            this.processInResponse(http2Connection, context, (HeadersFrame)firstHeaderFrame);
        }
    }

    private void processInRequest(Http2Connection http2Connection, FilterChainContext context, HeadersFrame headersFrame) throws IOException {
        boolean isExpectContent;
        Http2Request request = Http2Request.create();
        request.setConnection(context.getConnection());
        Http2Stream stream = http2Connection.acceptStream(request, headersFrame.getStreamId(), 0, 0);
        if (stream == null) {
            request.recycle();
            return;
        }
        DecoderUtils.decodeRequestHeaders(http2Connection, request);
        this.onHttpHeadersParsed(request, context);
        this.prepareIncomingRequest(stream, request);
        stream.onHeaderBlockRcv(headersFrame);
        if (headersFrame.isEndStream()) {
            request.setExpectContent(false);
        }
        if (!(isExpectContent = request.isExpectContent())) {
            stream.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
        }
        this.sendUpstream(http2Connection, stream, request, isExpectContent);
    }

    private void processInResponse(Http2Connection http2Connection, FilterChainContext context, HeadersFrame headersFrame) throws Http2ConnectionException, IOException {
        boolean isEOS;
        Http2Stream stream = http2Connection.getStream(headersFrame.getStreamId());
        if (stream == null) {
            return;
        }
        HttpRequestPacket request = stream.getRequest();
        HttpResponsePacket response = request.getResponse();
        if (response == null) {
            response = Http2Response.create();
        }
        if (isEOS = headersFrame.isEndStream()) {
            response.setExpectContent(false);
            stream.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
        }
        DecoderUtils.decodeResponseHeaders(http2Connection, response);
        this.onHttpHeadersParsed(response, context);
        stream.onHeaderBlockRcv(headersFrame);
        this.bind(request, response);
        if (isEOS) {
            this.onHttpPacketParsed(response, context);
        }
        this.sendUpstream(http2Connection, stream, response, !isEOS);
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Http2State http2State = Http2State.get(ctx.getConnection());
        if (http2State == null || http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        Object message = ctx.getMessage();
        Http2Connection http2Connection = this.obtainHttp2Connection(ctx, false);
        if (http2Connection.isHttp2OutputEnabled() && HttpPacket.isHttp(message)) {
            HttpPacket httpPacket = (HttpPacket)ctx.getMessage();
            HttpHeader httpHeader = httpPacket.getHttpHeader();
            if (httpHeader.isRequest()) {
                this.processOutgoingRequest(ctx, http2Connection, (HttpRequestPacket)httpHeader, httpPacket);
            } else {
                this.processOutgoingResponse(ctx, http2Connection, (HttpResponsePacket)httpHeader, httpPacket);
            }
        } else {
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            http2Connection.getOutputSink().writeDownStream(message, transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
        return ctx.getStopAction();
    }

    private void processOutgoingRequest(FilterChainContext ctx, Http2Connection http2Connection, HttpRequestPacket request, HttpPacket entireHttpPacket) throws IOException {
        Http2Stream stream;
        if (!http2Connection.isHttp2OutputEnabled()) {
            return;
        }
        if (!request.isCommitted()) {
            this.prepareOutgoingRequest(request);
        }
        if ((stream = Http2Stream.getStreamFor(request)) == null) {
            this.processOutgoingRequestForNewStream(ctx, http2Connection, request, entireHttpPacket);
        } else {
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            stream.getOutputSink().writeDownStream(entireHttpPacket, ctx, transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutgoingRequestForNewStream(FilterChainContext ctx, Http2Connection http2Connection, HttpRequestPacket request, HttpPacket entireHttpPacket) throws IOException {
        ReentrantLock newStreamLock = http2Connection.getNewClientStreamLock();
        newStreamLock.lock();
        try {
            Http2Stream stream = http2Connection.openStream(request, http2Connection.getNextLocalStreamId(), 0, 0, !request.isExpectContent());
            if (stream == null) {
                throw new IOException("Http2Connection is closed");
            }
            request.setAttribute(Http2Stream.HTTP2_STREAM_ATTRIBUTE, stream);
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            stream.getOutputSink().writeDownStream(entireHttpPacket, ctx, transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
        finally {
            newStreamLock.unlock();
        }
    }

    private void processOutgoingResponse(FilterChainContext ctx, Http2Connection http2Connection, HttpResponsePacket response, HttpPacket entireHttpPacket) throws IOException {
        Http2Stream stream = Http2Stream.getStreamFor(response);
        assert (stream != null);
        if (!response.isCommitted()) {
            this.prepareOutgoingResponse(response);
            this.pushAssociatedResoureses(ctx, stream);
        }
        FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
        stream.getOutputSink().writeDownStream(entireHttpPacket, ctx, transportContext.getCompletionHandler(), transportContext.getMessageCloner());
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (!Http2State.isHttp2(ctx.getConnection())) {
            return ctx.getInvokeAction();
        }
        Object type2 = event.type();
        if (type2 == TransportFilter.FlushEvent.TYPE) {
            assert (event instanceof TransportFilter.FlushEvent);
            HttpContext httpContext = HttpContext.get(ctx);
            Http2Stream stream = (Http2Stream)httpContext.getContextStorage();
            TransportFilter.FlushEvent flushEvent = (TransportFilter.FlushEvent)event;
            stream.outputSink.flush(flushEvent.getCompletionHandler());
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    boolean checkIfHttp2StreamChain(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (message == null) {
            Http2Stream http2Stream = (Http2Stream)HttpContext.get(ctx).getContextStorage();
            ctx.setMessage(http2Stream.pollInputData());
            return true;
        }
        HttpContent httpContent = (HttpContent)message;
        HttpHeader httpHeader = httpContent.getHttpHeader();
        return Http2Stream.getStreamFor(httpHeader) != null;
    }

    protected Http2Connection createHttp2Connection(DraftVersion draftVersion, Connection connection, boolean isServer) {
        Http2Connection http2Connection = draftVersion.newConnection(connection, isServer, this);
        if (this.initialWindowSize != -1) {
            http2Connection.setLocalStreamWindowSize(this.initialWindowSize);
        }
        if (this.maxConcurrentStreams != -1) {
            http2Connection.setLocalMaxConcurrentStreams(this.maxConcurrentStreams);
        }
        Http2Connection.bind(connection, http2Connection);
        return http2Connection;
    }

    protected void onPrefaceReceived(Http2Connection http2Connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUpstream(final Http2Connection http2Connection, final Http2Stream stream, final HttpHeader httpHeader, final boolean isExpectContent) {
        HttpRequestPacket request = stream.getRequest();
        HttpContext httpContext = HttpContext.newInstance(stream, stream, stream, request);
        request.getProcessingState().setHttpContext(httpContext);
        if (this.threadPool == null) {
            Threads.setService(true);
            try {
                http2Connection.sendMessageUpstream(stream, ((HttpContent.Builder)HttpContent.builder(httpHeader).last(!isExpectContent)).build());
            }
            finally {
                Threads.setService(false);
            }
        } else {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    http2Connection.sendMessageUpstream(stream, ((HttpContent.Builder)HttpContent.builder(httpHeader).last(!isExpectContent)).build());
                }
            });
        }
    }

    void prepareIncomingRequest(Http2Stream stream, Http2Request request) {
        ProcessingState state = request.getProcessingState();
        HttpResponsePacket response = request.getResponse();
        Method method = request.getMethod();
        if (stream.isPushStream() || Method.GET.equals(method) || Method.HEAD.equals(method) || !Method.CONNECT.equals(method) && request.getContentLength() == 0L) {
            request.setExpectContent(false);
        }
        try {
            request.getProtocol();
        }
        catch (IllegalStateException e) {
            state.setError(true);
            HttpStatus.HTTP_VERSION_NOT_SUPPORTED_505.setValues(response);
            request.setProtocol(Protocol.HTTP_1_1);
            return;
        }
        MimeHeaders headers = request.getHeaders();
        DataChunk hostDC = headers.getValue(Header.Host);
        if (hostDC == null || hostDC.getLength() == 0) {
            state.setError(true);
        }
    }

    private void prepareOutgoingRequest(HttpRequestPacket request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            request.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
        if (request.getContentLength() != -1L) {
            FIXED_LENGTH_ENCODING.prepareSerialize(null, request, null);
        }
    }

    private void prepareOutgoingResponse(HttpResponsePacket response) {
        response.setProtocol(Protocol.HTTP_2_0);
        String contentType = response.getContentType();
        if (contentType != null) {
            response.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
        if (response.getContentLength() != -1L) {
            FIXED_LENGTH_ENCODING.prepareSerialize(null, response, null);
        }
        if (!response.containsHeader(Header.Date)) {
            response.getHeaders().addValue(Header.Date).setBytes(FastHttpDateFormat.getCurrentDateBytes());
        }
    }

    void sendRstStream(FilterChainContext ctx, Http2Connection http2Connection, int streamId, ErrorCode errorCode) {
        RstStreamFrame rstStreamFrame = ((RstStreamFrame.RstStreamFrameBuilder)RstStreamFrame.builder().errorCode(errorCode).streamId(streamId)).build();
        ctx.write(this.frameCodec.serializeAndRecycle(http2Connection, rstStreamFrame));
    }

    private void sendGoAwayAndClose(FilterChainContext ctx, Http2Connection http2Connection, ErrorCode errorCode) {
        GoAwayFrame goAwayFrame = http2Connection.setGoAwayLocally(errorCode);
        if (goAwayFrame != null) {
            Connection connection = ctx.getConnection();
            ctx.write(this.frameCodec.serializeAndRecycle(http2Connection, goAwayFrame));
            connection.closeSilently();
        }
    }

    protected final Http2Connection obtainHttp2Connection(FilterChainContext context, boolean isUpStream) {
        return this.obtainHttp2Connection(null, context, isUpStream);
    }

    final Http2Connection obtainHttp2Connection(Http2State http2State, FilterChainContext context, boolean isUpStream) {
        Http2Connection http2Connection;
        Connection connection = context.getConnection();
        Http2Connection http2Connection2 = http2Connection = http2State != null ? http2State.getHttp2Connection() : null;
        if (http2Connection == null && (http2Connection = Http2Connection.get(connection)) == null) {
            http2Connection = this.createHttp2Connection(this.supportedHttp2Drafts[0], connection, true);
        }
        http2Connection.setupFilterChains(context, isUpStream);
        return http2Connection;
    }

    protected void sendSettings(Http2Connection http2Connection, FilterChainContext context) {
        context.write(this.frameCodec.serializeAndRecycle(http2Connection, http2Connection.prepareSettings().build()));
    }

    private void sendSettingsAck(Http2Connection http2Connection, FilterChainContext context) {
        SettingsFrame frame = SettingsFrame.builder().setAck().build();
        context.write(this.frameCodec.serializeAndRecycle(http2Connection, frame));
    }

    private static void processDataFrame(Http2Connection http2Connection, FilterChainContext context, DataFrame dataFrame) throws Http2StreamException {
        Buffer data = dataFrame.getData();
        Http2Stream stream = http2Connection.getStream(dataFrame.getStreamId());
        if (stream == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Data frame received for non-existent stream: connection={0}, frame={1}, stream={2}", new Object[]{context.getConnection(), dataFrame, dataFrame.getStreamId()});
            }
            int dataSize = data.remaining();
            dataFrame.recycle();
            http2Connection.ackConsumedData(dataSize);
            throw new Http2StreamException(dataFrame.getStreamId(), ErrorCode.STREAM_CLOSED);
        }
        Http2StreamException error = stream.assertCanAcceptData();
        if (error != null) {
            int dataSize = data.remaining();
            dataFrame.recycle();
            http2Connection.ackConsumedData(dataSize);
            throw error;
        }
        stream.offerInputData(data, dataFrame.isFlagSet(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAssociatedResoureses(FilterChainContext ctx, Http2Stream stream) throws IOException {
        Map<String, PushResource> pushResourceMap = stream.getAssociatedResourcesToPush();
        if (pushResourceMap != null) {
            int streamId = stream.getId();
            HttpRequestPacket streamReq = stream.getRequest();
            String referer = this.composeRefererOf(stream.getRequest());
            ArrayList<Pair<Http2Stream, Source>> pushStreams = new ArrayList<Pair<Http2Stream, Source>>(pushResourceMap.size());
            Http2Connection http2Connection = stream.getHttp2Connection();
            boolean isNewClientStreamLocked = true;
            boolean isDeflaterLocked = true;
            http2Connection.getNewClientStreamLock().lock();
            try {
                Http2Stream pushStream;
                for (Map.Entry<String, PushResource> entry : pushResourceMap.entrySet()) {
                    Map<String, String> extraHeaders;
                    String userAgent;
                    PushResource pushResource = entry.getValue();
                    Source source = pushResource.getSource();
                    Http2Request request = Http2Request.create();
                    HttpResponsePacket response = request.getResponse();
                    request.setRequestURI(entry.getKey());
                    request.setProtocol(Protocol.HTTP_2_0);
                    request.setMethod(Method.GET);
                    MimeHeaders reqHeaders = request.getHeaders();
                    DataChunk valueDC = reqHeaders.setValue(Header.Host);
                    if (valueDC.isNull()) {
                        valueDC.setString(streamReq.getHeader(Header.Host));
                    }
                    if ((userAgent = streamReq.getHeader(Header.UserAgent)) != null && (valueDC = reqHeaders.setValue(Header.UserAgent)).isNull()) {
                        valueDC.setString(userAgent);
                    }
                    if ((valueDC = reqHeaders.setValue(Header.Referer)).isNull()) {
                        valueDC.setString(referer);
                    }
                    for (String cookie : streamReq.getHeaders().values(Header.Cookie)) {
                        request.addHeader(Header.Cookie, cookie);
                    }
                    request.setSecure(streamReq.isSecure());
                    response.setStatus(pushResource.getStatusCode());
                    response.setProtocol(Protocol.HTTP_2_0);
                    response.setContentType(pushResource.getContentType());
                    if (source != null) {
                        response.setContentLengthLong(source.remaining());
                    }
                    if ((extraHeaders = pushResource.getHeaders()) != null) {
                        for (Map.Entry<String, String> headerEntry : extraHeaders.entrySet()) {
                            response.addHeader(headerEntry.getKey(), headerEntry.getValue());
                        }
                    }
                    this.prepareOutgoingRequest(request);
                    this.prepareOutgoingResponse(response);
                    try {
                        Http2Stream pushStream2 = http2Connection.openStream(request, http2Connection.getNextLocalStreamId(), streamId, pushResource.getPriority(), false);
                        pushStream2.inputBuffer.terminate(Constants.IN_FIN_TERMINATION);
                        pushStreams.add(new Pair<Http2Stream, Source>(pushStream2, source));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Can not push: " + entry.getKey(), e);
                    }
                }
                http2Connection.getDeflaterLock().lock();
                http2Connection.getNewClientStreamLock().unlock();
                isDeflaterLocked = true;
                isNewClientStreamLocked = false;
                List<Http2Frame> pushPromiseFrames = null;
                for (Pair pair : pushStreams) {
                    pushStream = (Http2Stream)pair.getFirst();
                    pushPromiseFrames = http2Connection.encodeHttpRequestAsPushPromiseFrames(ctx, pushStream.getRequest(), streamId, pushStream.getId(), pushPromiseFrames);
                }
                http2Connection.getOutputSink().writeDownStream(pushPromiseFrames);
                http2Connection.getDeflaterLock().unlock();
                isDeflaterLocked = false;
                for (Pair pair : pushStreams) {
                    pushStream = (Http2Stream)pair.getFirst();
                    pushStream.getOutputSink().writeDownStream((Source)pair.getSecond(), ctx);
                }
            }
            finally {
                if (isDeflaterLocked) {
                    http2Connection.getDeflaterLock().unlock();
                }
                if (isNewClientStreamLocked) {
                    http2Connection.getNewClientStreamLock().unlock();
                }
            }
        }
    }

    private String composeRefererOf(HttpRequestPacket request) {
        return (request.isSecure() ? "https" : "http") + "://" + request.getHeader(Header.Host) + request.getRequestURI();
    }
}

