/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.ejb.deployment.descriptor.TimeoutValueDescriptor;
import org.w3c.dom.Node;

public class TimeoutValueNode
extends DeploymentDescriptorNode<TimeoutValueDescriptor> {
    private static final Map<String, TimeUnit> elementToTimeUnit = new HashMap<String, TimeUnit>();
    private static final Map<TimeUnit, String> timeUnitToElement;
    private TimeoutValueDescriptor descriptor = null;

    @Override
    public TimeoutValueDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new TimeoutValueDescriptor();
        }
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("timeout".equals(element.getQName())) {
            this.descriptor.setValue(new Long(value));
        } else if ("unit".equals(element.getQName())) {
            this.descriptor.setUnit(elementToTimeUnit.get(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, TimeoutValueDescriptor desc) {
        Node timeoutNode = super.writeDescriptor(parent, nodeName, this.descriptor);
        TimeoutValueNode.appendTextChild(timeoutNode, "timeout", Long.toString(desc.getValue()));
        TimeoutValueNode.appendTextChild(timeoutNode, "unit", timeUnitToElement.get((Object)desc.getUnit()));
        return timeoutNode;
    }

    static {
        elementToTimeUnit.put("Days", TimeUnit.DAYS);
        elementToTimeUnit.put("Hours", TimeUnit.HOURS);
        elementToTimeUnit.put("Minutes", TimeUnit.MINUTES);
        elementToTimeUnit.put("Seconds", TimeUnit.SECONDS);
        elementToTimeUnit.put("Milliseconds", TimeUnit.MILLISECONDS);
        elementToTimeUnit.put("Microseconds", TimeUnit.MICROSECONDS);
        elementToTimeUnit.put("Nanoseconds", TimeUnit.NANOSECONDS);
        timeUnitToElement = new HashMap<TimeUnit, String>();
        for (String next : elementToTimeUnit.keySet()) {
            timeUnitToElement.put(elementToTimeUnit.get(next), next);
        }
    }
}

