/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.List;
import java.util.Map;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.InterceptorBindingDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class InterceptorBindingNode
extends DeploymentDescriptorNode<InterceptorBindingDescriptor> {
    private MethodDescriptor businessMethod = null;
    private boolean needsOverloadResolution = false;
    private InterceptorBindingDescriptor descriptor;

    @Override
    public InterceptorBindingDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new InterceptorBindingDescriptor();
        }
        return this.descriptor;
    }

    @Override
    public void startElement(XMLElement element, Attributes attributes) {
        if ("method".equals(element.getQName())) {
            this.businessMethod = new MethodDescriptor();
            this.needsOverloadResolution = true;
        } else if ("method-params".equals(element.getQName())) {
            this.needsOverloadResolution = false;
        }
        super.startElement(element, attributes);
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("method-name".equals(element.getQName())) {
            this.businessMethod.setName(value);
        } else if ("method-param".equals(element.getQName())) {
            if (value != null && value.trim().length() > 0) {
                this.businessMethod.addParameterClass(value.trim());
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public boolean endElement(XMLElement element) {
        if ("interceptor-order".equals(element.getQName())) {
            InterceptorBindingDescriptor desc = this.getDescriptor();
            desc.setIsTotalOrdering(true);
        } else if ("method-params".equals(element.getQName())) {
            if (this.businessMethod.getParameterClassNames() == null) {
                this.businessMethod.setEmptyParameterClassNames();
            }
        } else if ("method".equals(element.getQName())) {
            InterceptorBindingDescriptor bindingDesc = this.getDescriptor();
            this.businessMethod.setEjbClassSymbol("Bean");
            bindingDesc.setBusinessMethod(this.businessMethod);
            if (this.needsOverloadResolution) {
                bindingDesc.setNeedsOverloadResolution(true);
            }
            this.businessMethod = null;
            this.needsOverloadResolution = false;
        }
        return super.endElement(element);
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("ejb-name", "setEjbName");
        table.put("interceptor-class", "appendInterceptorClass");
        table.put("exclude-default-interceptors", "setExcludeDefaultInterceptors");
        table.put("exclude-class-interceptors", "setExcludeClassInterceptors");
        return table;
    }

    public void writeBindings(Node parent, EjbDescriptor ejbDesc) {
        List<EjbInterceptor> classInterceptors = ejbDesc.getInterceptorChain();
        if (classInterceptors.size() > 0) {
            this.writeTotalOrdering(parent, classInterceptors, ejbDesc, null);
        }
        Map<MethodDescriptor, List<EjbInterceptor>> methodInterceptorsMap = ejbDesc.getMethodInterceptorsMap();
        for (Map.Entry<MethodDescriptor, List<EjbInterceptor>> mapEntry : methodInterceptorsMap.entrySet()) {
            List<EjbInterceptor> interceptors = mapEntry.getValue();
            if (interceptors.isEmpty()) {
                this.writeExclusionBinding(parent, ejbDesc, mapEntry.getKey());
                continue;
            }
            this.writeTotalOrdering(parent, interceptors, ejbDesc, mapEntry.getKey());
        }
    }

    private void writeTotalOrdering(Node parent, List<EjbInterceptor> interceptors, EjbDescriptor ejbDesc, MethodDescriptor method) {
        Element bindingNode = InterceptorBindingNode.appendChild(parent, "interceptor-binding");
        InterceptorBindingNode.appendTextChild((Node)bindingNode, "ejb-name", ejbDesc.getName());
        Element totalOrderingNode = InterceptorBindingNode.appendChild(bindingNode, "interceptor-order");
        for (EjbInterceptor next : interceptors) {
            InterceptorBindingNode.appendTextChild((Node)totalOrderingNode, "interceptor-class", next.getInterceptorClassName());
        }
        if (method != null) {
            MethodNode methodNode = new MethodNode();
            methodNode.writeJavaMethodDescriptor(bindingNode, "method", method, true);
        }
    }

    private void writeExclusionBinding(Node parent, EjbDescriptor ejbDesc, MethodDescriptor method) {
        Element bindingNode = InterceptorBindingNode.appendChild(parent, "interceptor-binding");
        InterceptorBindingNode.appendTextChild((Node)bindingNode, "ejb-name", ejbDesc.getName());
        InterceptorBindingNode.appendTextChild((Node)bindingNode, "exclude-class-interceptors", "true");
        MethodNode methodNode = new MethodNode();
        methodNode.writeJavaMethodDescriptor(bindingNode, "method", method, true);
    }
}

