/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Local;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=EJB.class)
public class EJBHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        EJB ejbAn = (EJB)ainfo.getAnnotation();
        return this.processEJB(ainfo, rcContexts, ejbAn);
    }

    protected HandlerProcessingResult processEJB(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, EJB ejbAn) throws AnnotationProcessorException {
        String targetClassName;
        EjbReferenceDescriptor[] ejbRefs = null;
        String defaultLogicalName = null;
        Class<?> defaultBeanInterface = null;
        InjectionTarget target = null;
        if (ElementType.FIELD.equals((Object)ainfo.getElementType())) {
            Field f = (Field)ainfo.getAnnotatedElement();
            targetClassName = f.getDeclaringClass().getName();
            defaultLogicalName = targetClassName + "/" + f.getName();
            defaultBeanInterface = f.getType();
            target = new InjectionTarget();
            target.setClassName(targetClassName);
            target.setFieldName(f.getName());
            target.setMetadataSource(MetadataSource.ANNOTATION);
        } else if (ElementType.METHOD.equals((Object)ainfo.getElementType())) {
            Method m = (Method)ainfo.getAnnotatedElement();
            targetClassName = m.getDeclaringClass().getName();
            this.validateInjectionMethod(m, ainfo);
            String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
            defaultLogicalName = targetClassName + "/" + propertyName;
            defaultBeanInterface = m.getParameterTypes()[0];
            target = new InjectionTarget();
            target.setClassName(targetClassName);
            target.setMethodName(m.getName());
            target.setMetadataSource(MetadataSource.ANNOTATION);
        } else if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
            if (ejbAn.name().equals("") || ejbAn.beanInterface() == Object.class) {
                Class c = (Class)ainfo.getAnnotatedElement();
                AnnotationProcessorException fatalException = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtypelevelejb", "Invalid TYPE-level @EJB with name() = [{0}] and beanInterface = [{1}] in {2}.  Each TYPE-level @EJB must specify both name() and beanInterface().", ejbAn.name(), ejbAn.beanInterface(), c), ainfo);
                fatalException.setFatal(true);
                throw fatalException;
            }
        } else {
            return this.getDefaultFailedResult();
        }
        Class<?> beanInterface = ejbAn.beanInterface() == Object.class ? defaultBeanInterface : ejbAn.beanInterface();
        String logicalName = ejbAn.name().equals("") ? defaultLogicalName : ejbAn.name();
        for (EjbReferenceDescriptor ejbRef : ejbRefs = this.getEjbReferenceDescriptors(logicalName, rcContexts)) {
            if (target != null) {
                ejbRef.addInjectionTarget(target);
            }
            if (!StringUtils.ok(ejbRef.getName())) {
                ejbRef.setName(logicalName);
            }
            this.setEjbType(ejbRef, beanInterface);
            if (!StringUtils.ok(ejbRef.getDescription()) && StringUtils.ok(ejbAn.description())) {
                ejbRef.setDescription(ejbAn.description());
            }
            if (!ejbRef.hasLookupName() && StringUtils.ok(ejbAn.lookup())) {
                ejbRef.setLookupName(ejbAn.lookup());
            }
            if (!StringUtils.ok(ejbRef.getMappedName()) && StringUtils.ok(ejbAn.mappedName())) {
                ejbRef.setMappedName(ejbAn.mappedName());
            }
            if (StringUtils.ok(ejbRef.getLinkName()) || !StringUtils.ok(ejbAn.beanName())) continue;
            ejbRef.setLinkName(ejbAn.beanName());
        }
        return this.getDefaultProcessedResult();
    }

    private EjbReferenceDescriptor[] getEjbReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        EjbReferenceDescriptor[] ejbRefs = new EjbReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            EjbReferenceDescriptor ejbRef = (EjbReferenceDescriptor)rcContexts[i].getEjbReference(logicalName);
            if (ejbRef == null) {
                ejbRef = new EjbReferenceDescriptor();
                rcContexts[i].addEjbReferenceDescriptor(ejbRef);
            }
            ejbRefs[i] = ejbRef;
        }
        return ejbRefs;
    }

    private void setEjbType(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        if (EJBHome.class.isAssignableFrom(beanInterface) || EJBLocalHome.class.isAssignableFrom(beanInterface)) {
            this.setEjbHomeType(ejbRef, beanInterface);
        } else {
            this.setEjbIntfType(ejbRef, beanInterface);
        }
    }

    private void setEjbIntfType(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        if (ejbRef.getEjbInterface() != null) {
            return;
        }
        ejbRef.setEjbInterface(beanInterface.getName());
        if (beanInterface.getAnnotation(Local.class) != null) {
            ejbRef.setLocal(true);
        } else {
            ejbRef.setLocal(false);
        }
        ejbRef.setType("Session");
    }

    private void setEjbHomeType(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        String targetBeanType;
        block5: {
            if (ejbRef.getHomeClassName() != null) {
                return;
            }
            targetBeanType = "Session";
            ejbRef.setHomeClassName(beanInterface.getName());
            try {
                Method[] methods;
                for (Method m : methods = beanInterface.getMethods()) {
                    if (!m.getName().equals("create")) continue;
                    ejbRef.setEjbInterface(m.getReturnType().getName());
                    break;
                }
                for (Method m : methods) {
                    if (!m.getName().equals("findByPrimaryKey")) continue;
                    targetBeanType = "Entity";
                    break;
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.FINE)) break block5;
                this.logger.log(Level.FINE, "component intf / ejb type annotation processing error", e);
            }
        }
        ejbRef.setLocal(EJBLocalHome.class.isAssignableFrom(beanInterface));
        ejbRef.setType(targetBeanType);
    }
}

