/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.logging.annotation.LogMessageInfo;

public class ClientArtifactsManager {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Artifact {0} identified for inclusion in app clients after one or more app clients were generated.", level="SEVERE", cause="The application might specify that modules are to be processed in the order they appear in the application and an app client module appears before a module that creates an artifact to be included in app clients.", action="Make sure, if the application specifies initialize-in-order as true, that the app clients appear after other modules which generated artifacts that should be accessible to app clients.")
    private static final String CLIENT_ARTIFACT_OUT_OF_ORDER = "NCLS-DEPLOYMENT-00025";
    @LogMessageInfo(message="Artifact with relative path {0} expected at {1} but does not exist or cannot be read", level="SEVERE", cause="The server is attempting to register an artifact to be included in the generated client JAR but the artifact does not exist or cannot be read", action="This is an internal server error.  Please file a bug report.")
    private static final String CLIENT_ARTIFACT_MISSING = "NCLS-DEPLOYMENT-00026";
    @LogMessageInfo(message="Artifact with relative path {0} from {1} collides with an existing artifact from file {2}", level="SEVERE", cause="The server has created more than one artifact with the same relative path to be included in the generated client JAR file", action="This is an internal server error.  Please file a bug report.")
    private static final String CLIENT_ARTIFACT_COLLISION = "NCLS-DEPLOYMENT-00027";
    private boolean isArtifactSetConsumed = false;
    private static final String CLIENT_ARTIFACTS_KEY = "ClientArtifacts";
    private final Map<URI, Artifacts.FullAndPartURIs> artifacts = new HashMap<URI, Artifacts.FullAndPartURIs>();
    private final Map<URI, JarFile> jarFiles = new HashMap<URI, JarFile>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientArtifactsManager get(DeploymentContext dc) {
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            ClientArtifactsManager result = dc.getTransientAppMetaData(CLIENT_ARTIFACTS_KEY, ClientArtifactsManager.class);
            if (result == null) {
                result = new ClientArtifactsManager();
                dc.addTransientAppMetaData(CLIENT_ARTIFACTS_KEY, result);
            }
            return result;
        }
    }

    public void add(URI baseURI, URI artifactURI) {
        URIPair uris = new URIPair(baseURI, artifactURI);
        Artifacts.FullAndPartURIs newArtifact = new Artifacts.FullAndPartURIs(uris.absoluteURI, uris.relativeURI);
        this.add(newArtifact);
    }

    public void add(File baseFile, File artifactFile) {
        this.add(baseFile.toURI(), artifactFile.toURI());
    }

    public void add(File artifactFile, String relativePath, boolean isTemporary) {
        Artifacts.FullAndPartURIs artifact = new Artifacts.FullAndPartURIs(artifactFile.toURI(), relativePath, isTemporary);
        this.add(artifact);
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty();
    }

    public void add(Artifacts.FullAndPartURIs artifact) {
        boolean isLogAdditions = deplLogger.isLoggable(Level.FINE);
        if (this.isArtifactSetConsumed) {
            throw new IllegalStateException(this.formattedString(CLIENT_ARTIFACT_OUT_OF_ORDER, artifact.getFull().toASCIIString()));
        }
        Artifacts.FullAndPartURIs existingArtifact = this.artifacts.get(artifact.getPart());
        if (existingArtifact != null) {
            throw new IllegalArgumentException(this.formattedString(CLIENT_ARTIFACT_COLLISION, artifact.getPart().toASCIIString(), artifact.getFull().toASCIIString(), existingArtifact.getFull().toASCIIString()));
        }
        String scheme = artifact.getFull().getScheme();
        if (scheme.equals("file")) {
            this.verifyFileArtifact(artifact);
        } else if (scheme.equals("jar")) {
            this.verifyJarEntryArtifact(artifact);
        } else {
            throw new IllegalArgumentException(artifact.getFull().toASCIIString() + " != [file,jar]");
        }
        if (isLogAdditions) {
            String stackTrace = deplLogger.isLoggable(Level.FINER) ? Arrays.toString(Thread.currentThread().getStackTrace()) : "";
            deplLogger.log(Level.FINE, "ClientArtifactsManager added {0}\n{1}", new Object[]{artifact, stackTrace});
        }
        this.artifacts.put(artifact.getPart(), artifact);
    }

    private void verifyFileArtifact(Artifacts.FullAndPartURIs artifact) {
        URI fullURI = artifact.getFull();
        File f = new File(fullURI);
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException(this.formattedString(CLIENT_ARTIFACT_MISSING, artifact.getPart().toASCIIString(), fullURI.toASCIIString()));
        }
    }

    private void verifyJarEntryArtifact(Artifacts.FullAndPartURIs artifact) {
        String entryName;
        JarEntry jarEntry;
        URI fullURI = artifact.getFull();
        String ssp = fullURI.getSchemeSpecificPart();
        JarFile jf = this.jarFiles.get(fullURI);
        if (jf == null) {
            try {
                String jarFilePath = ssp.substring(0, ssp.indexOf("!/"));
                URI jarURI = new URI(jarFilePath);
                File jar = new File(jarURI);
                jf = new JarFile(jar);
                this.jarFiles.put(fullURI, jf);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if ((jarEntry = jf.getJarEntry(entryName = ssp.substring(ssp.indexOf("!/") + 2))) == null) {
            throw new IllegalArgumentException(this.formattedString("enterprise.deployment.backend.appClientArtifactMissing", artifact.getPart().toASCIIString(), fullURI.toASCIIString()));
        }
    }

    public void addAll(File baseFile, Collection<File> artifactFiles) {
        for (File f : artifactFiles) {
            this.add(baseFile, f);
        }
    }

    public boolean contains(URI baseURI, URI artifactURI) {
        return this.artifacts.containsKey(artifactURI);
    }

    public boolean contains(File baseFile, File artifactFile) {
        return this.contains(baseFile.toURI(), artifactFile.toURI());
    }

    public Collection<Artifacts.FullAndPartURIs> artifacts() {
        this.isArtifactSetConsumed = true;
        this.closeOpenedJARs();
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "ClientArtifactsManager returned artifacts");
        }
        return Collections.unmodifiableCollection(this.artifacts.values());
    }

    private void closeOpenedJARs() {
        for (JarFile jarFile : this.jarFiles.values()) {
            try {
                jarFile.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.jarFiles.clear();
    }

    private String formattedString(String key, Object ... args) {
        String format = deplLogger.getResourceBundle().getString(key);
        return MessageFormat.format(format, args);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isArtifactSetConsumed) {
            this.closeOpenedJARs();
        }
    }

    private static class URIPair {
        private final URI relativeURI;
        private final URI absoluteURI;

        private URIPair(URI baseURI, URI artifactURI) {
            if (artifactURI.isAbsolute()) {
                this.absoluteURI = artifactURI;
                this.relativeURI = baseURI.relativize(this.absoluteURI);
            } else {
                this.relativeURI = artifactURI;
                this.absoluteURI = baseURI.resolve(this.relativeURI);
            }
        }
    }
}

